/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ResizingTable
extends JTable {
    public ResizingTable() {
        this.initColumns();
    }

    public ResizingTable(TableModel tableModel, TableColumnModel columnModel) {
        super(tableModel, columnModel);
    }

    public ResizingTable(TableModel model) {
        super(model);
        this.initColumns();
    }

    private void initColumns() {
        this.setIntercellSpacing(new Dimension(3, 3));
        this.setAutoResizeMode(0);
        this.setColumnWidths();
    }

    public void tableChanged(TableModelEvent event) {
        super.tableChanged(event);
        if (this.defaultRenderersByColumnClass != null) {
            this.setColumnWidths();
        }
    }

    private void setColumnWidths() {
        if (this.columnModel == null) {
            return;
        }
        int[] width = new int[this.getColumnCount()];
        this.getHeaderWidths(width);
        this.getCellMaxWidths(width);
        this.setCellWidths(width, false);
    }

    private void getHeaderWidths(int[] width) {
        JTableHeader header = this.getTableHeader();
        for (int column = 0; column < width.length; ++column) {
            TableCellRenderer renderer = this.columnModel.getColumn(column).getHeaderRenderer();
            if (renderer == null && (header == null || (renderer = header.getDefaultRenderer()) == null)) continue;
            Component comp = renderer.getTableCellRendererComponent(this, this.getColumnName(column), false, false, -1, column);
            Dimension prefSize = comp.getPreferredSize();
            if (prefSize.width <= width[column]) continue;
            width[column] = prefSize.width;
        }
    }

    private void setCellWidths(int[] width, boolean override) {
        int spacingWidth = this.getIntercellSpacing().width * 2;
        for (int column = 0; column < width.length; ++column) {
            TableColumn tableColumn = this.columnModel.getColumn(column);
            int newWidth = width[column] + spacingWidth + 6;
            if (override) {
                tableColumn.setPreferredWidth(newWidth);
                continue;
            }
            int currentWidth = tableColumn.getWidth();
            tableColumn.setPreferredWidth(Math.max(currentWidth, newWidth));
        }
    }

    private void getCellMaxWidths(int[] width) {
        int rowCount = this.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < width.length; ++column) {
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                if (renderer == null) {
                    renderer = this.getDefaultRenderer(this.getModel().getColumnClass(column));
                }
                if (renderer == null) continue;
                Object value = this.getValueAt(row, column);
                boolean isSelected = this.isCellSelected(row, column);
                Component comp = renderer.getTableCellRendererComponent(this, value, isSelected, false, row, column);
                width[column] = Math.max(comp.getPreferredSize().width, width[column]);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = this.getPreferredSize();
        Dimension maxSize = this.getMaximumSize();
        Dimension minSize = this.getMinimumSize();
        int width = Math.max(Math.min(maxSize.width, prefSize.width), minSize.width);
        int height = Math.max(Math.min(maxSize.height, prefSize.height), minSize.height);
        return new Dimension(width, height);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getSize().width;
    }
}

