/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.PolicyTreeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.AbstractTreeNode;
import org.exist.client.xacml.NodeChangeListener;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.PolicyElementContainer;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.PolicyNode;
import org.exist.client.xacml.PolicySetNode;
import org.exist.client.xacml.XACMLTreeNode;

public class RootNode
extends AbstractTreeNode
implements PolicyElementContainer {
    private List children;
    private List originalChildren;
    private List listeners = new ArrayList(2);

    public RootNode() {
        super(null);
        this.children = new ArrayList();
        this.originalChildren = Collections.EMPTY_LIST;
    }

    public void add(PolicyTreeElement element) {
        this.add(-1, element);
    }

    public void add(int index, PolicyTreeElement element) {
        if (element == null) {
            return;
        }
        if (element instanceof Policy) {
            this.add(index, new PolicyNode((NodeContainer)this, (Policy)element));
        } else if (element instanceof PolicySet) {
            this.add(index, new PolicySetNode((NodeContainer)this, (PolicySet)element));
        } else {
            throw new IllegalArgumentException("Only Policies and PolicySets can be top level elements.");
        }
    }

    public void add(PolicyElementNode node) {
        this.add(-1, node);
    }

    public void add(int index, PolicyElementNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof AbstractPolicyNode) {
            if (index < 0) {
                index = this.children.size();
            }
        } else {
            throw new IllegalArgumentException("Only PolicyNodes and PolicySetNodes can be top level elements.");
        }
        this.children.add(index, node);
        this.setModified(true);
        this.nodeAdded(node, index);
    }

    public void remove(PolicyElementNode node) {
        if (node == null) {
            return;
        }
        int index = this.children.indexOf(node);
        if (index < 0) {
            return;
        }
        this.children.remove(index);
        this.setModified(true);
        this.nodeRemoved(node, index);
    }

    public boolean containsId(String id) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            if (!((AbstractPolicyNode)it.next()).getId().toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public XACMLTreeNode getChild(int index) {
        return (XACMLTreeNode)this.children.get(index);
    }

    public int indexOfChild(Object child) {
        return this.children.indexOf(child);
    }

    public boolean isModified(boolean deep) {
        if (super.isModified(deep)) {
            return true;
        }
        if (deep) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                PolicyElementNode child = (PolicyElementNode)it.next();
                if (!child.isModified(true)) continue;
                return true;
            }
        }
        return false;
    }

    public void revert(boolean deep) {
        this.children = this.originalChildren;
        if (deep) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ((PolicyElementNode)it.next()).revert(true);
            }
        }
        super.revert(deep);
    }

    public void commit(boolean deep) {
        this.originalChildren = this.children;
        if (deep) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ((PolicyElementNode)it.next()).commit(true);
            }
        }
        super.commit(deep);
    }

    public Set getRemovedDocumentNames() {
        HashSet<String> ret = new HashSet<String>();
        Iterator originalIt = this.originalChildren.iterator();
        while (originalIt.hasNext()) {
            AbstractPolicyNode originalChild = (AbstractPolicyNode)originalIt.next();
            String documentName = originalChild.getDocumentName();
            if (this.documentNameExists(documentName)) continue;
            ret.add(documentName);
        }
        return ret;
    }

    private boolean documentNameExists(String documentName) {
        Iterator currentIt = this.children.iterator();
        while (currentIt.hasNext()) {
            AbstractPolicyNode currentChild = (AbstractPolicyNode)currentIt.next();
            String currentDocName = currentChild.getDocumentName();
            if (currentDocName == null || !currentDocName.equals(documentName)) continue;
            return true;
        }
        return false;
    }

    public void addNodeChangeListener(NodeChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeNodeChangeListener(NodeChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void nodeChanged(XACMLTreeNode node) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((NodeChangeListener)it.next()).nodeChanged(node);
        }
    }

    public void nodeAdded(XACMLTreeNode node, int newIndex) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((NodeChangeListener)it.next()).nodeAdded(node, newIndex);
        }
    }

    public void nodeRemoved(XACMLTreeNode removedNode, int oldChildIndex) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((NodeChangeListener)it.next()).nodeRemoved(removedNode, oldChildIndex);
        }
    }

    public String serialize(boolean indent) {
        throw new UnsupportedOperationException("Cannot serialize the root node");
    }
}

