/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cluster;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import org.exist.EXistException;
import org.exist.Indexer;
import org.exist.cluster.ClusterComunication;
import org.exist.cluster.ClusterException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.DBBroker;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.SyntaxException;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ClusterCollection
extends Collection {
    Collection collection;

    private Collection getWrappedCollection(Collection collection) {
        if (collection instanceof ClusterCollection) {
            return this.getWrappedCollection(((ClusterCollection)collection).collection);
        }
        return collection;
    }

    public ClusterCollection(Collection collection) {
        this.collection = this.getWrappedCollection(collection);
    }

    public void store(Txn txn, DBBroker broker, IndexInfo info, String data, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        InputSource is = new InputSource(new ByteArrayInputStream(data.getBytes()));
        this.store(txn, broker, info, is, privileged);
    }

    public void removeXMLResource(Txn transaction, DBBroker broker, XmldbURI docURI) throws PermissionDeniedException, TriggerException, LockException {
        this.collection.removeXMLResource(transaction, broker, docURI);
        try {
            ClusterComunication cluster = ClusterComunication.getInstance();
            if (cluster != null) {
                cluster.removeDocument(this.getURI().toString(), docURI.toString());
            }
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public void store(Txn transaction, DBBroker broker, IndexInfo info, InputSource source, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        Indexer indexer = info.getIndexer();
        DocumentImpl document = indexer.getDocument();
        this.collection.store(transaction, broker, info, source, privileged);
        InputStream is = source.getByteStream();
        Reader cs = source.getCharacterStream();
        String uri = null;
        String content = "";
        try {
            byte[] b = new byte[1];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (is != null) {
                is.reset();
                while (is.read(b) != -1) {
                    bos.write(b);
                }
            } else if (cs != null) {
                if (cs != null) {
                    int c;
                    cs.reset();
                    while ((c = cs.read()) != -1) {
                        bos.write(c);
                    }
                }
            } else {
                uri = source.getSystemId();
                URL url = new URL(uri);
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
                StringBuffer buffer = new StringBuffer();
                String line = null;
                while ((line = br.readLine()) != null) {
                    buffer.append(line).append(System.getProperty("line.separator"));
                }
                content = buffer.toString();
            }
            bos.flush();
            bos.close();
            if (uri == null) {
                content = bos.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ClusterComunication cluster = ClusterComunication.getInstance();
            if (cluster != null) {
                cluster.storeDocument(this.getURI().toString(), document.getFileURI().toString(), content);
            }
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI name, byte[] data, String mimeType) throws EXistException, PermissionDeniedException, LockException, TriggerException {
        return this.collection.addBinaryResource(transaction, broker, name, data, mimeType);
    }

    public Lock getLock() {
        return this.collection.getLock();
    }

    public void addCollection(DBBroker broker, Collection child, boolean isNew) {
        try {
            this.collection.addCollection(broker, child, isNew);
            String childName = child.getURI().lastSegment().toString();
            System.out.println("________ ADDDING COLLECTION " + child.getURI() + " TO " + this.getURI());
            ClusterComunication cluster = ClusterComunication.getInstance();
            if (cluster != null) {
                cluster.addCollection(this.getURI().toString(), childName);
            }
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public void removeCollection(XmldbURI name) throws LockException {
        try {
            this.collection.removeCollection(name);
            System.out.println("REMOVED COLLECTION " + name);
            ClusterComunication cluster = ClusterComunication.getInstance();
            if (cluster != null) {
                cluster.removeCollection(this.getURI().toString(), name.toString());
            }
        }
        catch (ClusterException e) {
            e.printStackTrace();
        }
    }

    public boolean hasChildCollection(XmldbURI name) {
        return this.collection.hasChildCollection(name);
    }

    public void release(int mode) {
        this.collection.release(mode);
    }

    public void update(Collection child) {
        this.collection.update(child);
    }

    public void addDocument(Txn transaction, DBBroker broker, DocumentImpl doc) {
        this.collection.addDocument(transaction, broker, doc);
    }

    public Iterator collectionIterator() {
        return this.collection.collectionIterator();
    }

    public List getDescendants(DBBroker broker, User user) {
        return this.collection.getDescendants(broker, user);
    }

    public DocumentSet allDocs(DBBroker broker, DocumentSet docs, boolean recursive, boolean checkPermissions) {
        return this.collection.allDocs(broker, docs, recursive, checkPermissions);
    }

    public DocumentSet getDocuments(DBBroker broker, DocumentSet docs, boolean checkPermissions) {
        return this.collection.getDocuments(broker, docs, checkPermissions);
    }

    public boolean allowUnload() {
        return this.collection.allowUnload();
    }

    public int compareTo(Object obj) {
        return this.collection.compareTo(obj);
    }

    public boolean equals(Object obj) {
        return this.collection.equals(obj);
    }

    public int getChildCollectionCount() {
        return this.collection.getChildCollectionCount();
    }

    public DocumentImpl getDocument(DBBroker broker, XmldbURI name) {
        return this.collection.getDocument(broker, name);
    }

    public DocumentImpl getDocumentWithLock(DBBroker broker, XmldbURI name) throws LockException {
        return this.collection.getDocumentWithLock(broker, name);
    }

    public DocumentImpl getDocumentWithLock(DBBroker broker, XmldbURI name, int lockMode) throws LockException {
        return this.collection.getDocumentWithLock(broker, name, lockMode);
    }

    public void releaseDocument(DocumentImpl doc) {
        this.collection.releaseDocument(doc);
    }

    public void releaseDocument(DocumentImpl doc, int mode) {
        this.collection.releaseDocument(doc, mode);
    }

    public int getDocumentCount() {
        return this.collection.getDocumentCount();
    }

    public int getId() {
        return this.collection.getId();
    }

    public XmldbURI getURI() {
        return this.collection.getURI();
    }

    public XmldbURI getParentURI() {
        return this.collection.getParentURI();
    }

    public Permission getPermissions() {
        return this.collection.getPermissions();
    }

    public Permission getPermissionsNoLock() {
        return this.collection.getPermissionsNoLock();
    }

    public boolean hasDocument(XmldbURI name) {
        return this.collection.hasDocument(name);
    }

    public boolean hasSubcollection(XmldbURI name) {
        return this.collection.hasSubcollection(name);
    }

    public boolean hasSubcollectionNoLock(XmldbURI name) {
        return this.collection.hasSubcollectionNoLock(name);
    }

    public Iterator iterator(DBBroker broker) {
        return this.collection.iterator(broker);
    }

    public void read(DBBroker broker, VariableByteInput istream) throws IOException {
        this.collection.read(broker, istream);
    }

    public void removeBinaryResource(Txn transaction, DBBroker broker, XmldbURI docname) throws PermissionDeniedException, LockException, TriggerException {
        this.collection.removeBinaryResource(transaction, broker, docname);
    }

    public void removeBinaryResource(Txn transaction, DBBroker broker, DocumentImpl doc) throws PermissionDeniedException, LockException, TriggerException {
        this.collection.removeBinaryResource(transaction, broker, doc);
    }

    public IndexInfo validateXMLResource(Txn txn, DBBroker broker, XmldbURI name, InputSource source) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        return this.collection.validateXMLResource(txn, broker, name, source);
    }

    public IndexInfo validateXMLResource(Txn txn, DBBroker broker, XmldbURI name, String data) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        return this.collection.validateXMLResource(txn, broker, name, data);
    }

    public IndexInfo validateXMLResource(Txn txn, DBBroker broker, XmldbURI name, Node node) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        return this.collection.validateXMLResource(txn, broker, name, node);
    }

    public void store(Txn txn, DBBroker broker, IndexInfo info, Node node, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        this.collection.store(txn, broker, info, node, privileged);
    }

    public void setId(int id) {
        this.collection.setId(id);
    }

    public void setPermissions(int mode) throws LockException {
        this.collection.setPermissions(mode);
    }

    public void setPermissions(String mode) throws SyntaxException, LockException {
        this.collection.setPermissions(mode);
    }

    public void setPermissions(Permission permissions) throws LockException {
        this.collection.setPermissions(permissions);
    }

    public void write(DBBroker broker, VariableByteOutputStream ostream) throws IOException {
        this.collection.write(broker, ostream);
    }

    public void setAddress(long addr) {
        this.collection.setAddress(addr);
    }

    public long getAddress() {
        return this.collection.getAddress();
    }

    public void setCreationTime(long ms) {
        this.collection.setCreationTime(ms);
    }

    public long getCreationTime() {
        return this.collection.getCreationTime();
    }

    public void setTriggersEnabled(boolean enabled) {
        this.collection.setTriggersEnabled(enabled);
    }

    public void setReader(XMLReader reader) {
        this.collection.setReader(reader);
    }

    public void addObserver(Observer o) {
        this.collection.addObserver(o);
    }

    public void deleteObservers() {
        this.collection.deleteObservers();
    }

    public long getKey() {
        return this.collection.getKey();
    }

    public int getReferenceCount() {
        return this.collection.getReferenceCount();
    }

    public int incReferenceCount() {
        return this.collection.incReferenceCount();
    }

    public int decReferenceCount() {
        return this.collection.decReferenceCount();
    }

    public void setReferenceCount(int count) {
        this.collection.setReferenceCount(count);
    }

    public void setTimestamp(int timestamp) {
        this.collection.setTimestamp(timestamp);
    }

    public int getTimestamp() {
        return this.collection.getTimestamp();
    }

    public boolean sync(boolean syncJournal) {
        return this.collection.sync(syncJournal);
    }

    public boolean isDirty() {
        return this.collection.isDirty();
    }

    public String toString() {
        return this.collection.toString();
    }
}

