/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import org.exist.collections.Collection;
import org.exist.storage.BrokerPool;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRDCache;
import org.exist.storage.lock.Lock;
import org.exist.util.hashtable.Long2ObjectHashMap;
import org.exist.util.hashtable.Object2LongHashMap;
import org.exist.xmldb.XmldbURI;

public class CollectionCache
extends LRDCache {
    private Object2LongHashMap names;
    private BrokerPool pool;

    public CollectionCache(BrokerPool pool, int blockBuffers, double growthThreshold) {
        super(blockBuffers, 1.8, growthThreshold, "DATA");
        this.names = new Object2LongHashMap(blockBuffers);
        this.pool = pool;
        this.setFileName("collections.dbx");
    }

    public void add(Collection collection) {
        this.add(collection, 1);
    }

    public void add(Collection collection, int initialRefCount) {
        super.add(collection, initialRefCount);
        String name = collection.getURI().getRawCollectionPath();
        this.names.put(name, collection.getKey());
    }

    public Collection get(Collection collection) {
        return (Collection)this.get(collection.getKey());
    }

    public Collection get(XmldbURI name) {
        long key = this.names.get(name.getRawCollectionPath());
        if (key < 0L) {
            return null;
        }
        return (Collection)this.get(key);
    }

    protected Cacheable removeOne(Cacheable item) {
        Collection old;
        double rd = 0.0;
        double minRd = -1.0;
        int bucket = -1;
        for (int i = 0; i < this.items.length; ++i) {
            old = (Collection)this.items[i];
            if (old == null) {
                bucket = i;
                break;
            }
            Lock lock = old.getLock();
            rd = (double)old.getReferenceCount() / (double)(this.totalReferences - old.getTimestamp());
            if (!lock.attempt(0)) continue;
            if ((minRd < 0.0 || rd < minRd) && old.allowUnload()) {
                minRd = rd;
                bucket = i;
            }
            lock.release(0);
        }
        if (bucket < 0) {
            bucket = 0;
        }
        if ((old = (Collection)this.items[bucket]) != null) {
            if (this.pool.getConfigurationManager() != null) {
                this.pool.getConfigurationManager().invalidate(old.getURI());
            }
            this.map.remove(old.getKey());
            this.names.remove(old.getURI().getRawCollectionPath());
            old.sync(true);
        }
        this.items[bucket] = item;
        this.map.put(item.getKey(), item);
        this.accounting.replacedPage(item);
        if (this.cacheManager != null && this.accounting.resizeNeeded()) {
            this.accounting.stats();
            this.cacheManager.requestMem(this);
        }
        return old;
    }

    public void remove(Cacheable item) {
        Collection col = (Collection)item;
        super.remove(item);
        this.names.remove(col.getURI().getRawCollectionPath());
        if (this.pool.getConfigurationManager() != null) {
            this.pool.getConfigurationManager().invalidate(col.getURI());
        }
    }

    public int getRealSize() {
        int size = 0;
        for (int i = 0; i < this.items.length; ++i) {
            Collection item = (Collection)this.items[i];
            if (item == null) continue;
            size += item.getMemorySize();
        }
        return size;
    }

    public void resize(int newSize) {
        if (newSize < this.size) {
            this.shrink(newSize);
            this.names = new Object2LongHashMap(newSize);
        } else {
            LOG.debug((Object)("Growing cache from " + this.size + " to " + newSize));
            Cacheable[] newItems = new Cacheable[newSize];
            Long2ObjectHashMap newMap = new Long2ObjectHashMap(newSize);
            Object2LongHashMap newNames = new Object2LongHashMap(newSize);
            for (int i = 0; i < this.count; ++i) {
                newItems[i] = this.items[i];
                if (this.items[i] == null) continue;
                newMap.put(this.items[i].getKey(), this.items[i]);
                newNames.put(((Collection)this.items[i]).getURI().getRawCollectionPath(), this.items[i].getKey());
            }
            this.size = newSize;
            this.map = newMap;
            this.names = newNames;
            this.items = newItems;
            this.accounting.reset();
            this.accounting.setTotalSize(this.size);
        }
    }
}

