/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import org.exist.dom.DocumentImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NewArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NodeSetHelper {
    public static NodeSet selectParentChild(NodeSet dl, NodeSet al, int mode, int contextId) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentImpl lastDoc = null;
        switch (mode) {
            case 1: {
                NodeSetIterator i = dl.iterator();
                while (i.hasNext()) {
                    NodeProxy parent;
                    int sizeHint = -1;
                    NodeProxy child = (NodeProxy)i.next();
                    if (lastDoc == null || child.getDocument() != lastDoc) {
                        lastDoc = child.getDocument();
                        sizeHint = dl.getSizeHint(lastDoc);
                    }
                    if ((parent = al.parentWithChild(child, true, false, -1)) == null) continue;
                    if (-1 != contextId) {
                        child.deepCopyContext(parent, contextId);
                    } else {
                        child.copyContext(parent);
                    }
                    result.add(child, sizeHint);
                }
                break;
            }
            case 0: {
                NodeSetIterator i = dl.iterator();
                while (i.hasNext()) {
                    NodeProxy parent;
                    int sizeHint = -1;
                    NodeProxy child = (NodeProxy)i.next();
                    if (lastDoc == null || child.getDocument() != lastDoc) {
                        lastDoc = child.getDocument();
                        sizeHint = al.getSizeHint(lastDoc);
                    }
                    if ((parent = al.parentWithChild(child, true, false, -1)) == null) continue;
                    if (-1 != contextId) {
                        parent.deepCopyContext(child, contextId);
                    } else {
                        parent.copyContext(child);
                    }
                    parent.addMatches(child);
                    result.add(parent, sizeHint);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad 'mode' argument");
            }
        }
        result.sort();
        return result;
    }

    public static NodeSet selectAncestorDescendant(NodeSet dl, NodeSet al, int mode, boolean includeSelf, int contextId) {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentImpl lastDoc = null;
        switch (mode) {
            case 1: {
                NodeSetIterator i = dl.iterator();
                while (i.hasNext()) {
                    NodeProxy ancestor;
                    int sizeHint = -1;
                    NodeProxy descendant = (NodeProxy)i.next();
                    if (lastDoc == null || descendant.getDocument() != lastDoc) {
                        lastDoc = descendant.getDocument();
                        sizeHint = dl.getSizeHint(lastDoc);
                    }
                    if ((ancestor = al.parentWithChild(descendant.getDocument(), descendant.getNodeId(), false, includeSelf)) == null) continue;
                    if (-1 != contextId) {
                        descendant.addContextNode(contextId, ancestor);
                    } else {
                        descendant.copyContext(ancestor);
                    }
                    result.add(descendant, sizeHint);
                }
                break;
            }
            case 0: {
                NodeSetIterator i = dl.iterator();
                while (i.hasNext()) {
                    NodeProxy ancestor;
                    int sizeHint = -1;
                    NodeProxy descendant = (NodeProxy)i.next();
                    if (lastDoc == null || descendant.getDocument() != lastDoc) {
                        lastDoc = descendant.getDocument();
                        sizeHint = al.getSizeHint(lastDoc);
                    }
                    if ((ancestor = al.parentWithChild(descendant.getDocument(), descendant.getNodeId(), false, includeSelf)) == null) continue;
                    if (-1 != contextId) {
                        ancestor.addContextNode(contextId, descendant);
                    } else {
                        ancestor.copyContext(descendant);
                    }
                    result.add(ancestor, sizeHint);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad 'mode' argument");
            }
        }
        return result;
    }

    public static NodeSet selectAncestors(NodeSet al, NodeSet dl, boolean includeSelf, int contextId) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        NodeSetIterator i = dl.iterator();
        while (i.hasNext()) {
            NodeProxy descendant = (NodeProxy)i.next();
            NodeSet ancestors = NodeSetHelper.ancestorsForChild(al, descendant, false, includeSelf);
            NodeSetIterator j = ancestors.iterator();
            while (j.hasNext()) {
                NodeProxy ancestor = (NodeProxy)j.next();
                if (ancestor == null) continue;
                NodeProxy temp = result.get(ancestor);
                if (temp == null) {
                    if (-2 != contextId) {
                        if (-1 != contextId) {
                            ancestor.addContextNode(contextId, descendant);
                        } else {
                            ancestor.copyContext(descendant);
                        }
                    }
                    ancestor.addMatches(descendant);
                    result.add(ancestor);
                    continue;
                }
                if (-1 == contextId) continue;
                temp.addContextNode(contextId, descendant);
            }
        }
        return result;
    }

    private static NodeSet ancestorsForChild(NodeSet ancestors, NodeProxy child, boolean directParent, boolean includeSelf) {
        NewArrayNodeSet result = new NewArrayNodeSet(5);
        NodeId nodeId = child.getNodeId();
        NodeProxy temp = ancestors.get(child.getDocument(), nodeId);
        if (includeSelf && temp != null) {
            result.add(temp);
        }
        while (nodeId != null && nodeId != NodeId.DOCUMENT_NODE) {
            nodeId = nodeId.getParentId();
            temp = ancestors.get(child.getDocument(), nodeId);
            if (temp != null) {
                result.add(temp);
                continue;
            }
            if (!directParent) continue;
            return result;
        }
        return result;
    }

    public static NodeSet selectPrecedingSiblings(NodeSet candidates, NodeSet references, int contextId) {
        if (references.isEmpty() || candidates.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iReferences = references.iterator();
        NodeSetIterator iCandidates = candidates.iterator();
        NodeProxy reference = (NodeProxy)iReferences.next();
        NodeProxy candidate = (NodeProxy)iCandidates.next();
        NodeProxy firstCandidate = null;
        while (true) {
            if (reference.getDocument().getDocId() < candidate.getDocument().getDocId()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (reference.getDocument().getDocId() > candidate.getDocument().getDocId()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            int cmp = candidate.getNodeId().getParentId().compareTo(reference.getNodeId().getParentId());
            if (cmp > 0 && candidate.getNodeId().getTreeLevel() <= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (cmp < 0 || cmp > 0 && candidate.getNodeId().getTreeLevel() >= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (firstCandidate == null) {
                firstCandidate = candidate;
            }
            if ((cmp = candidate.getNodeId().compareTo(reference.getNodeId())) < 0) {
                NodeProxy t = result.get(candidate);
                if (t == null) {
                    if (-2 != contextId) {
                        if (-1 == contextId) {
                            candidate.copyContext(reference);
                        } else {
                            candidate.addContextNode(contextId, reference);
                        }
                    }
                    result.add(candidate);
                } else if (contextId > -1) {
                    t.addContextNode(contextId, reference);
                }
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (cmp > 0) {
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (!iReferences.hasNext()) break;
            reference = (NodeProxy)iReferences.next();
            iCandidates.setPosition(firstCandidate);
            candidate = (NodeProxy)iCandidates.next();
        }
        return result;
    }

    public static NodeSet selectFollowingSiblings(NodeSet candidates, NodeSet references, int contextId) {
        if (references.isEmpty() || candidates.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iReferences = references.iterator();
        NodeSetIterator iCandidates = candidates.iterator();
        NodeProxy reference = (NodeProxy)iReferences.next();
        NodeProxy candidate = (NodeProxy)iCandidates.next();
        NodeProxy firstCandidate = null;
        while (true) {
            if (reference.getDocument().getDocId() < candidate.getDocument().getDocId()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (reference.getDocument().getDocId() > candidate.getDocument().getDocId()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            int cmp = candidate.getNodeId().getParentId().compareTo(reference.getNodeId().getParentId());
            if (cmp > 0 && candidate.getNodeId().getTreeLevel() <= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                continue;
            }
            if (cmp < 0 || cmp > 0 && candidate.getNodeId().getTreeLevel() >= reference.getNodeId().getTreeLevel()) {
                firstCandidate = null;
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (firstCandidate == null) {
                firstCandidate = candidate;
            }
            if ((cmp = candidate.getNodeId().compareTo(reference.getNodeId())) < 0) {
                if (!iCandidates.hasNext()) break;
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (cmp > 0) {
                NodeProxy t = result.get(candidate);
                if (t == null) {
                    if (-2 != contextId) {
                        if (-1 == contextId) {
                            candidate.copyContext(reference);
                        } else {
                            candidate.addContextNode(contextId, reference);
                        }
                    }
                    result.add(candidate);
                } else {
                    t.addContextNode(contextId, reference);
                }
                result.add(candidate);
                if (iCandidates.hasNext()) {
                    candidate = (NodeProxy)iCandidates.next();
                    continue;
                }
                if (!iReferences.hasNext()) break;
                reference = (NodeProxy)iReferences.next();
                iCandidates.setPosition(firstCandidate);
                candidate = (NodeProxy)iCandidates.next();
                continue;
            }
            if (!iCandidates.hasNext()) break;
            candidate = (NodeProxy)iCandidates.next();
        }
        return result;
    }

    public static NodeSet selectPreceding(NodeSet references, NodeSet candidates) throws XPathException {
        if (candidates.isEmpty() || references.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iReferences = references.iterator();
        while (iReferences.hasNext()) {
            NodeProxy reference = (NodeProxy)iReferences.next();
            NodeSetIterator iCandidates = candidates.iterator();
            while (iCandidates.hasNext()) {
                NodeProxy candidate = (NodeProxy)iCandidates.next();
                if (!candidate.before(reference, true)) continue;
                candidate.addContextNode(-1, reference);
                result.add(candidate);
            }
        }
        return result;
    }

    public static NodeSet selectFollowing(NodeSet references, NodeSet candidates) throws XPathException {
        if (candidates.isEmpty() || references.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iReferences = references.iterator();
        while (iReferences.hasNext()) {
            NodeProxy reference = (NodeProxy)iReferences.next();
            NodeSetIterator iCandidates = candidates.iterator();
            while (iCandidates.hasNext()) {
                NodeProxy candidate = (NodeProxy)iCandidates.next();
                if (!candidate.after(reference, true)) continue;
                candidate.addContextNode(-1, reference);
                result.add(candidate);
            }
        }
        return result;
    }

    public static NodeSet directSelectAttributes(DBBroker broker, NodeSet candidates, NodeTest test, int contextId) {
        if (candidates.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator iCandidates = candidates.iterator();
        while (iCandidates.hasNext()) {
            NodeProxy candidate = (NodeProxy)iCandidates.next();
            result.addAll(candidate.directSelectAttribute(broker, test, contextId));
        }
        return result;
    }

    public static final void copyChildren(Document new_doc, Node node, Node new_node) {
        NodeList children = node.getChildNodes();
        block5: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null) continue;
            switch (child.getNodeType()) {
                case 1: {
                    Node new_child = NodeSetHelper.copyNode(new_doc, child);
                    new_node.appendChild(new_child);
                    continue block5;
                }
                case 2: {
                    Node new_child = NodeSetHelper.copyNode(new_doc, child);
                    ((Element)new_node).setAttributeNode((Attr)new_child);
                    continue block5;
                }
                case 3: {
                    Node new_child = NodeSetHelper.copyNode(new_doc, child);
                    new_node.appendChild(new_child);
                }
            }
        }
    }

    public static final Node copyNode(Document new_doc, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                Element new_node = new_doc.createElementNS(node.getNamespaceURI(), node.getNodeName());
                NodeSetHelper.copyChildren(new_doc, node, new_node);
                return new_node;
            }
            case 3: {
                Text new_node = new_doc.createTextNode(((Text)node).getData());
                return new_node;
            }
            case 2: {
                Attr new_node = new_doc.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                new_node.setValue(((Attr)node).getValue());
                return new_node;
            }
        }
        return null;
    }
}

