/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.QNamePool;
import org.exist.storage.BrokerPool;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteInputStream;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.util.Configuration;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.util.hashtable.Object2IntHashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SymbolTable {
    public static final String FILE_NAME = "symbols.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.symbol-table";
    public static final short FILE_FORMAT_VERSION_ID = 7;
    public static int LENGTH_LOCAL_NAME = 2;
    public static int LENGTH_NS_URI = 2;
    protected Object2IntHashMap nameSymbols = new Object2IntHashMap(200);
    protected Int2ObjectHashMap names = new Int2ObjectHashMap(200);
    protected Object2IntHashMap nsSymbols = new Object2IntHashMap(200);
    protected Int2ObjectHashMap namespaces = new Int2ObjectHashMap(200);
    protected Object2IntHashMap defaultMappings = new Object2IntHashMap(200);
    protected QNamePool namePool = new QNamePool();
    protected Object2IntHashMap mimeTypeByName = new Object2IntHashMap(32);
    protected Int2ObjectHashMap mimeTypeById = new Int2ObjectHashMap(32);
    protected short max = 0;
    protected short nsMax = 0;
    protected boolean changed = false;
    protected File file;

    public SymbolTable(BrokerPool pool, String dataDir, Configuration config) throws EXistException {
        this.file = new File(dataDir + File.separatorChar + SymbolTable.getFileName());
        if (!this.file.canRead()) {
            this.saveSymbols();
        } else {
            this.loadSymbols();
        }
        config.setProperty(SymbolTable.getConfigKeyForFile(), this);
    }

    public static String getFileName() {
        return FILE_NAME;
    }

    public static String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    public synchronized QName getQName(short type, String namespaceURI, String localName, String prefix) {
        byte itype = type == 2 ? (byte)1 : 0;
        QName qn = this.namePool.get(itype, namespaceURI, localName, prefix);
        if (qn == null) {
            qn = this.namePool.add(itype, namespaceURI, localName, prefix);
        }
        return qn;
    }

    public synchronized short getSymbol(Element element) {
        short id = (short)this.nameSymbols.get(element.getLocalName());
        if (id != -1) {
            return id;
        }
        id = this.max = (short)(this.max + 1);
        this.nameSymbols.put(element.getLocalName(), id);
        this.names.put(id, element.getLocalName());
        this.changed = true;
        String prefix = element.getPrefix();
        if (prefix != null && prefix.length() > 0 && !this.defaultMappings.containsKey(prefix)) {
            short nsId = this.getNSSymbol(element.getNamespaceURI());
            this.defaultMappings.put(prefix, nsId);
        }
        return id;
    }

    public synchronized short getSymbol(Attr attr) {
        String key = '@' + attr.getLocalName();
        short id = (short)this.nameSymbols.get(key);
        if (id != -1) {
            return id;
        }
        id = this.max = (short)(this.max + 1);
        this.nameSymbols.put(key, id);
        this.names.put(id, attr.getLocalName());
        this.changed = true;
        String prefix = attr.getPrefix();
        if (prefix != null && prefix.length() > 0 && !this.defaultMappings.containsKey(prefix)) {
            short nsId = this.getNSSymbol(attr.getNamespaceURI());
            this.defaultMappings.put(prefix, nsId);
        }
        return id;
    }

    public synchronized short getSymbol(String name) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        short id = (short)this.nameSymbols.get(name);
        if (id != -1) {
            return id;
        }
        id = this.max = (short)(this.max + 1);
        this.nameSymbols.put(name, id);
        this.names.put(id, name);
        this.changed = true;
        return id;
    }

    public synchronized short getNSSymbol(String ns) {
        if (ns == null || ns.length() == 0) {
            return 0;
        }
        short id = (short)this.nsSymbols.get(ns);
        if (id != -1) {
            return id;
        }
        id = this.nsMax = (short)(this.nsMax + 1);
        this.nsSymbols.put(ns, id);
        this.namespaces.put(id, ns);
        this.changed = true;
        return id;
    }

    public synchronized String getNamespace(short id) {
        return id == 0 ? "" : (String)this.namespaces.get(id);
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized String getName(short id) {
        return (String)this.names.get(id);
    }

    public synchronized String getDefaultNamespace(String prefix) {
        if (this.defaultMappings.containsKey(prefix)) {
            return this.getNamespace((short)this.defaultMappings.get(prefix));
        }
        return null;
    }

    public synchronized String[] defaultPrefixList() {
        String[] prefixes = new String[this.defaultMappings.size()];
        int i = 0;
        Iterator j = this.defaultMappings.iterator();
        while (j.hasNext()) {
            prefixes[i] = (String)j.next();
            ++i;
        }
        return prefixes;
    }

    public synchronized int getMimeTypeId(String mimeType) {
        int id = this.mimeTypeByName.get(mimeType);
        if (id == -1) {
            int maxId = 0;
            Iterator i = this.mimeTypeById.iterator();
            while (i.hasNext()) {
                Integer val = (Integer)i.next();
                maxId = Math.max(maxId, val);
            }
            id = ++maxId;
            this.mimeTypeByName.put(mimeType, id);
            this.mimeTypeById.put(id, mimeType);
            this.changed = true;
        }
        return id;
    }

    public synchronized String getMimeType(int id) {
        return (String)this.mimeTypeById.get(id);
    }

    public synchronized void write(VariableByteOutputStream ostream) throws IOException {
        short id;
        String entry;
        ostream.writeFixedInt(7);
        ostream.writeShort(this.max);
        ostream.writeShort(this.nsMax);
        ostream.writeInt(this.nameSymbols.size());
        Iterator i = this.nameSymbols.iterator();
        while (i.hasNext()) {
            entry = (String)i.next();
            ostream.writeUTF(entry);
            id = (short)this.nameSymbols.get(entry);
            if (id < 0) {
                Thread.dumpStack();
            }
            ostream.writeShort(id);
        }
        ostream.writeInt(this.nsSymbols.size());
        i = this.nsSymbols.iterator();
        while (i.hasNext()) {
            entry = (String)i.next();
            ostream.writeUTF(entry);
            id = (short)this.nsSymbols.get(entry);
            if (id < 0) {
                Thread.dumpStack();
            }
            ostream.writeShort(id);
        }
        ostream.writeInt(this.defaultMappings.size());
        Iterator i2 = this.defaultMappings.iterator();
        while (i2.hasNext()) {
            String prefix = (String)i2.next();
            short nsId = (short)this.defaultMappings.get(prefix);
            ostream.writeUTF(prefix);
            ostream.writeShort(nsId);
        }
        ostream.writeInt(this.mimeTypeByName.size());
        Iterator i3 = this.mimeTypeByName.iterator();
        while (i3.hasNext()) {
            String mime = (String)i3.next();
            int mimeId = this.mimeTypeByName.get(mime);
            ostream.writeUTF(mime);
            ostream.writeInt(mimeId);
        }
        this.changed = false;
    }

    public synchronized void read(VariableByteInput istream) throws IOException {
        short id;
        String name;
        int i;
        int magic = istream.readFixedInt();
        if (magic != 7) {
            throw new IOException("Database file symbols.dbx has a storage format incompatible with this version of eXist. Please do a backup/restore of your data first.");
        }
        this.max = istream.readShort();
        this.nsMax = istream.readShort();
        int count = istream.readInt();
        for (i = 0; i < count; ++i) {
            name = istream.readUTF();
            id = istream.readShort();
            this.nameSymbols.put(name, id);
            if (name.charAt(0) == '@') {
                this.names.put(id, name.substring(1));
                continue;
            }
            this.names.put(id, name);
        }
        count = istream.readInt();
        for (i = 0; i < count; ++i) {
            name = istream.readUTF();
            id = istream.readShort();
            this.nsSymbols.put(name, id);
            this.namespaces.put(id, name);
        }
        count = istream.readInt();
        for (int i2 = 0; i2 < count; ++i2) {
            String prefix = istream.readUTF();
            short nsId = istream.readShort();
            this.defaultMappings.put(prefix, nsId);
        }
        count = istream.readInt();
        for (int i3 = 0; i3 < count; ++i3) {
            String mime = istream.readUTF();
            int mimeId = istream.readInt();
            this.mimeTypeByName.put(mime, mimeId);
            this.mimeTypeById.put(mimeId, mime);
        }
        this.changed = false;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSymbols() throws EXistException {
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            try {
                VariableByteOutputStream os = new VariableByteOutputStream(256);
                this.write(os);
                FileOutputStream fos = new FileOutputStream(this.getFile().getAbsolutePath(), false);
                fos.write(os.toByteArray());
                fos.close();
            }
            catch (FileNotFoundException e) {
                throw new EXistException("file not found: " + this.getFile().getAbsolutePath());
            }
            catch (IOException e) {
                throw new EXistException("io error occurred while creating " + this.getFile().getAbsolutePath());
            }
        }
    }

    public void loadSymbols() throws EXistException {
        try {
            FileInputStream fis = new FileInputStream(this.getFile());
            VariableByteInputStream is = new VariableByteInputStream(fis);
            this.read(is);
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new EXistException("could not read " + this.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new EXistException("io error occurred while reading " + this.getFile().getAbsolutePath() + ": " + e.getMessage());
        }
    }

    public void backupSymbolsTo(OutputStream os) throws IOException {
        int len;
        FileInputStream fis = new FileInputStream(this.getFile());
        byte[] buf = new byte[1024];
        while ((len = fis.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        fis.close();
    }

    public void flush() throws EXistException {
        if (this.hasChanged()) {
            this.saveSymbols();
        }
    }
}

