/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.exist.util.serializer.DOMSerializer;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;

public class XMLUtil {
    private static Logger LOG = Logger.getLogger((String)XMLUtil.class.getName());

    public static final String dump(DocumentFragment fragment) {
        StringWriter writer = new StringWriter();
        DOMSerializer serializer = new DOMSerializer();
        serializer.setWriter(writer);
        try {
            serializer.serialize(fragment);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final String encodeAttrMarkup(String str) {
        StringBuffer buf = new StringBuffer();
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    boolean isEntity = false;
                    for (int j = i + 1; j < str.length(); ++j) {
                        if (str.charAt(j) == ';') {
                            isEntity = true;
                            break;
                        }
                        if (!Character.isLetter(str.charAt(j))) break;
                    }
                    if (isEntity) {
                        buf.append('&');
                        continue block6;
                    }
                    buf.append("&amp;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static final String decodeAttrMarkup(String str) {
        StringBuffer out = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int p;
            char ch = str.charAt(i);
            if (ch == '&' && (p = str.indexOf(59, i)) != -1) {
                String ent = str.substring(i + 1, p);
                if (ent.equals("amp")) {
                    out.append('&');
                } else if (ent.equals("lt")) {
                    out.append('<');
                } else if (ent.equals("gt")) {
                    out.append('>');
                } else if (ent.equals("quot")) {
                    out.append('\"');
                }
                i = p;
                continue;
            }
            out.append(ch);
        }
        return out.toString();
    }

    public static final String getEncoding(String xmlDecl) {
        if (xmlDecl == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int p0 = xmlDecl.indexOf("encoding");
        if (p0 == -1) {
            return null;
        }
        for (int i = p0 + 8; i < xmlDecl.length(); ++i) {
            if (Character.isWhitespace(xmlDecl.charAt(i)) || xmlDecl.charAt(i) == '=') continue;
            if (xmlDecl.charAt(i) == '\"') {
                while (xmlDecl.charAt(++i) != '\"' && i < xmlDecl.length()) {
                    buf.append(xmlDecl.charAt(i));
                }
                return buf.toString();
            }
            return null;
        }
        return null;
    }

    public static final String getXMLDecl(byte[] data) {
        boolean foundTag = false;
        for (int i = 0; i < data.length && !foundTag; ++i) {
            if (data[i] != 60) continue;
            foundTag = true;
            if (data[i + 1] != 63 || data[i + 2] != 120 || data[i + 3] != 109 || data[i + 4] != 108) continue;
            for (int j = i + 5; j < data.length; ++j) {
                if (data[j] != 63 || data[j + 1] != 62) continue;
                String xmlDecl = new String(data, i, j - i + 2);
                return xmlDecl;
            }
        }
        return null;
    }

    public static final String readFile(File file) throws IOException {
        return XMLUtil.readFile(file, "ISO-8859-1");
    }

    public static String readFile(File file, String defaultEncoding) throws IOException {
        return XMLUtil.readFile(new FileInputStream(file), defaultEncoding);
    }

    public static String readFile(InputSource is) throws IOException {
        return XMLUtil.readFile(is.getByteStream(), is.getEncoding());
    }

    public static String readFile(InputStream in, String defaultEncoding) throws IOException {
        int l;
        byte[] chunk = new byte[512];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        do {
            if ((l = in.read(chunk)) <= 0) continue;
            out.write(chunk, 0, l);
        } while (l > -1);
        in.close();
        byte[] data = out.toByteArray();
        String xmlDecl = XMLUtil.getXMLDecl(data);
        String enc = XMLUtil.getEncoding(xmlDecl);
        if (enc == null) {
            enc = defaultEncoding;
        }
        try {
            return new String(out.toByteArray(), enc);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            return new String(out.toByteArray());
        }
    }

    public static String parseValue(String value, String key) {
        int p = value.indexOf(key);
        if (p == -1) {
            return null;
        }
        return XMLUtil.parseValue(value, p);
    }

    public static String parseValue(String value, int p) {
        while (p < value.length() && value.charAt(++p) != '\"') {
        }
        if (p == value.length()) {
            return null;
        }
        int e = ++p;
        while (e < value.length() && value.charAt(++e) != '\"') {
        }
        if (e == value.length()) {
            return null;
        }
        return value.substring(p, e);
    }
}

