/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fulltext;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.exist.backup.RawDataBackup;
import org.exist.fulltext.FTIndexWorker;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.storage.index.BFile;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;

public class FTIndex
extends AbstractIndex
implements RawBackupSupport {
    private static final Logger LOG = Logger.getLogger((Class)FTIndex.class);
    public static final String ID = FTIndex.class.getName();
    public static final String FILE_NAME = "words.dbx";
    private static final String CONFIG_ATTR_FILE = "file";
    private File dataFile;
    private BFile db;

    public void configure(BrokerPool pool, String dataDir, Element config) throws DatabaseConfigurationException {
        super.configure(pool, dataDir, config);
        String fileName = FILE_NAME;
        if (config.hasAttribute(CONFIG_ATTR_FILE)) {
            fileName = config.getAttribute(CONFIG_ATTR_FILE);
        }
        this.dataFile = new File(dataDir + File.separatorChar + fileName);
    }

    public void open() throws DatabaseConfigurationException {
        double cacheGrowth = 1.4;
        double cacheKeyThresdhold = 0.01;
        double cacheValueThresHold = 0.015;
        LOG.debug((Object)("Creating '" + this.dataFile.getName() + "'..."));
        try {
            this.db = new BFile(this.pool, 0, false, this.dataFile, this.pool.getCacheManager(), cacheGrowth, cacheKeyThresdhold, cacheValueThresHold);
        }
        catch (DBException e) {
            throw new DatabaseConfigurationException("Failed to create index file: " + this.dataFile.getAbsolutePath() + ": " + e.getMessage());
        }
    }

    public void close() throws DBException {
        this.db.close();
    }

    public void sync() throws DBException {
        this.db.flush();
    }

    public void remove() throws DBException {
        this.db.closeAndRemove();
        this.db = null;
    }

    public IndexWorker getWorker(DBBroker broker) {
        try {
            return new FTIndexWorker(this, broker);
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn((Object)("Failed to create index worker for full text index: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    public BFile getBFile() {
        return this.db;
    }

    public void backupToArchive(RawDataBackup backup) throws IOException {
        OutputStream os = backup.newEntry(this.db.getFile().getName());
        this.db.backupToStream(os);
        backup.closeEntry();
    }
}

