/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedDownloadThread;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.io.BlockingInputStream;
import org.exist.storage.io.BlockingOutputStream;

public class EmbeddedInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger((Class)EmbeddedInputStream.class);
    private BlockingInputStream bis;
    private BlockingOutputStream bos;
    private EmbeddedDownloadThread rt;

    public EmbeddedInputStream(XmldbURL xmldbURL) throws MalformedURLException {
        logger.debug((Object)"Initializing EmbeddedInputStream");
        this.bis = new BlockingInputStream();
        this.bos = this.bis.getOutputStream();
        this.rt = new EmbeddedDownloadThread(xmldbURL, this.bos);
        this.rt.start();
        logger.debug((Object)"Initializing EmbeddedInputStream done");
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.bis.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    public void reset() throws IOException {
        this.bis.reset();
    }

    public int read() throws IOException {
        return this.bis.read();
    }

    public void close() throws IOException {
        this.bis.close();
    }

    public int available() throws IOException {
        return this.bis.available();
    }
}

