/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.protocols.xmldb;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.log4j.Logger;
import org.exist.protocolhandler.protocols.xmldb.Connection;

public class Handler
extends URLStreamHandler {
    private static final Logger LOG = Logger.getLogger((Class)Handler.class);
    public static final String XMLDB_EXIST = "xmldb:exist:";
    public static final String XMLDB = "xmldb:";
    public static final String PATTERN = "xmldb:[\\w]+:\\/\\/.*";

    public Handler() {
        LOG.debug((Object)"Setup \"xmldb:exist:\" handler");
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        LOG.debug((Object)spec);
        if (spec.startsWith("xmldb:exist://")) {
            LOG.debug((Object)"Parsing xmldb:exist:// URL.");
            super.parseURL(url, spec, XMLDB_EXIST.length(), limit);
        } else if (spec.startsWith("xmldb://")) {
            LOG.debug((Object)"Parsing xmldb:// URL.");
            super.parseURL(url, spec, XMLDB.length(), limit);
        } else if (spec.matches(PATTERN)) {
            LOG.debug((Object)"Parsing URL with custom exist instance");
            String[] splits = spec.split(":", 3);
            String instance = splits[1];
            int seperator = spec.indexOf("//");
            super.parseURL(url, spec, seperator, limit);
        } else if (spec.startsWith("xmldb:://")) {
            int seperator = spec.indexOf("//");
            super.parseURL(url, spec, seperator, limit);
        } else if (spec.startsWith("xmldb:/")) {
            super.parseURL(url, spec, start, limit);
        } else {
            LOG.error((Object)("Expected 'xmldb:'-like URL, found " + spec));
            super.parseURL(url, spec, start, limit);
        }
    }

    protected URLConnection openConnection(URL u) throws IOException {
        return new Connection(u);
    }
}

