/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmlrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.io.ExistIOException;

public class XmlrpcDownload {
    private static final Logger LOG = Logger.getLogger((Class)XmlrpcDownload.class);

    public void stream(XmldbURL xmldbURL, OutputStream os) throws IOException {
        LOG.debug((Object)"Begin document download");
        try {
            XmlRpcClient client = new XmlRpcClient();
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setEncoding("UTF-8");
            config.setEnabledForExtensions(true);
            config.setServerURL(new URL(xmldbURL.getXmlRpcURL()));
            if (xmldbURL.hasUserInfo()) {
                config.setBasicUserName(xmldbURL.getUsername());
                config.setBasicPassword(xmldbURL.getPassword());
            }
            client.setConfig((XmlRpcClientConfig)config);
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("indent", "no");
            options.put("encoding", "UTF-8");
            Vector<Object> params = new Vector<Object>();
            params.addElement(xmldbURL.getCollectionPath());
            params.addElement(options);
            Hashtable ht = (Hashtable)client.execute("getDocumentData", params);
            int offset = (Integer)ht.get("offset");
            byte[] data = (byte[])ht.get("data");
            String handle = (String)ht.get("handle");
            os.write(data);
            while (offset != 0) {
                params.clear();
                params.addElement(handle);
                params.addElement(new Integer(offset));
                ht = (Hashtable)client.execute("getNextChunk", params);
                data = (byte[])ht.get("data");
                offset = (Integer)ht.get("offset");
                os.write(data);
            }
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new ExistIOException(ex.getMessage(), ex);
        }
        finally {
            LOG.debug((Object)"Finished document download");
        }
    }
}

