/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.ExistPDP;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

public interface SecurityManager {
    public static final String ACL_FILE = "users.xml";
    public static final XmldbURI ACL_FILE_URI = XmldbURI.create("users.xml");
    public static final String DBA_GROUP = "dba";
    public static final String DBA_USER = "admin";
    public static final String GUEST_GROUP = "guest";
    public static final String GUEST_USER = "guest";
    public static final User SYSTEM_USER = new User("admin", null, "dba");

    public void attach(BrokerPool var1, DBBroker var2);

    public boolean isXACMLEnabled();

    public ExistPDP getPDP();

    public void deleteUser(String var1) throws PermissionDeniedException;

    public void deleteUser(User var1) throws PermissionDeniedException;

    public User getUser(String var1);

    public User getUser(int var1);

    public User[] getUsers();

    public void addGroup(String var1);

    public boolean hasGroup(String var1);

    public Group getGroup(String var1);

    public Group getGroup(int var1);

    public String[] getGroups();

    public boolean hasAdminPrivileges(User var1);

    public boolean hasUser(String var1);

    public void setUser(User var1);

    public int getResourceDefaultPerms();

    public int getCollectionDefaultPerms();
}

