/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.SymbolTable;
import org.exist.dom.TextImpl;
import org.exist.dom.VirtualNodeSet;
import org.exist.fulltext.ElementContent;
import org.exist.fulltext.FTMatch;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.DBBroker;
import org.exist.storage.FulltextIndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.OccurrenceList;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.RegexMatcher;
import org.exist.storage.Signatures;
import org.exist.storage.TermMatcher;
import org.exist.storage.TextSearchEngine;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.index.BFile;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteArray;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.ProgressIndicator;
import org.exist.util.ReadOnlyException;
import org.exist.util.UTF8;
import org.exist.util.XMLString;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;

public class NativeTextEngine
extends TextSearchEngine
implements ContentLoadingObserver {
    public static final String FILE_NAME = "words.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.words";
    public static final double DEFAULT_WORD_CACHE_GROWTH = 1.4;
    public static final double DEFAULT_WORD_KEY_THRESHOLD = 0.01;
    public static final double DEFAULT_WORD_VALUE_THRESHOLD = 0.015;
    public static final byte TEXT_SECTION = 0;
    public static final byte ATTRIBUTE_SECTION = 1;
    public static final byte QNAME_SECTION = 2;
    private static final byte IDX_GENERIC = 0;
    private static final byte IDX_QNAME = 1;
    public static int ATTRIBUTE_BY_QNAME = 0;
    public static int ATTRIBUTE_NOT_BY_QNAME = 1;
    public static int TOKENIZE = 0;
    public static int DO_NOT_TOKENIZE = 1;
    public static int TEXT_BY_QNAME = 2;
    public static int FOURTH_OPTION = 3;
    public static final int LENGTH_NODE_TYPE = 1;
    public static final int LENGTH_NODE_IDS_FREQ_OFFSETS = 4;
    public static final int OFFSET_NODE_TYPE = 0;
    public static final int OFFSET_ELEMENT_CHILDREN_COUNT = 1;
    public static final int OFFSET_ATTRIBUTE_DLN_LENGTH = 1;
    public static final int OFFSET_TEXT_DLN_LENGTH = 1;
    public static final int OFFSET_DLN = 3;
    public static final int MAX_TOKEN_LENGTH = 2048;
    protected BFile dbTokens;
    protected InvertedIndex invertedIndex;
    private DocumentImpl doc;
    private VariableByteOutputStream os = new VariableByteOutputStream(7);

    public NativeTextEngine(DBBroker broker, BFile dbFile, Configuration config) throws DBException {
        super(broker, config);
        this.invertedIndex = new InvertedIndex();
        this.dbTokens = dbFile;
    }

    public String getFileName() {
        return FILE_NAME;
    }

    public String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    public NativeTextEngine getInstance() {
        return this;
    }

    public static final boolean containsWildcards(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '*': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean startsWithWildcard(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        switch (str.charAt(0)) {
            case '*': 
            case '?': 
            case '[': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    public int getTrackMatches() {
        return this.trackMatches;
    }

    public void setTrackMatches(int flags) {
        this.trackMatches = flags;
    }

    public void setDocument(DocumentImpl document) {
        if (this.doc != null && this.doc.getDocId() != document.getDocId()) {
            this.flush();
        }
        this.doc = document;
        this.invertedIndex.setDocument(this.doc);
    }

    public void storeAttribute(AttrImpl node, NodePath currentPath, int indexingHint, FulltextIndexSpec indexSpec, boolean remove) {
        if ((indexingHint & ATTRIBUTE_BY_QNAME) == ATTRIBUTE_BY_QNAME || (indexingHint & ATTRIBUTE_NOT_BY_QNAME) == ATTRIBUTE_NOT_BY_QNAME) {
            TextToken token;
            this.tokenizer.setText(node.getValue().toLowerCase());
            while (null != (token = this.tokenizer.nextToken())) {
                if (token.length() > 2048 || this.stoplist.contains(token) || !token.isAlpha() && indexSpec != null && !indexSpec.getIncludeAlphaNum()) continue;
                if (indexingHint == ATTRIBUTE_BY_QNAME) {
                    this.invertedIndex.addAttribute(token, node, remove);
                    continue;
                }
                this.invertedIndex.addAttribute(token, node.getNodeId(), remove);
            }
        }
    }

    public void storeAttribute(AttrImpl node, NodePath currentPath, int indexingHint, RangeIndexSpec idx, boolean remove) {
    }

    public void storeText(TextImpl node, int indexingHint, FulltextIndexSpec indexSpec, boolean remove) {
        if (indexingHint == TOKENIZE || indexingHint == DO_NOT_TOKENIZE) {
            XMLString t = node.getXMLString().transformToLower();
            if (indexingHint == DO_NOT_TOKENIZE) {
                TextToken token = new TextToken(1, t, 0, t.length());
                this.invertedIndex.addText(token, node.getNodeId(), remove);
            } else if (indexingHint == TOKENIZE) {
                TextToken token;
                this.tokenizer.setText(t);
                while (null != (token = this.tokenizer.nextToken())) {
                    if (token.length() > 2048 || this.stoplist.contains(token) || indexSpec != null && !indexSpec.getIncludeAlphaNum() && !token.isAlpha()) continue;
                    this.invertedIndex.addText(token, node.getNodeId(), remove);
                }
            }
        }
    }

    public void storeText(StoredNode parent, ElementContent text, int indexingHint, FulltextIndexSpec indexSpec, boolean remove) {
        XMLString data = null;
        int currentOffset = 0;
        for (ElementContent.TextSpan span = text.getFirst(); span != null; span = span.getNext()) {
            TextToken token;
            if (data == null) {
                data = span.getContent().transformToLower();
            } else {
                currentOffset = data.length();
                data.append(span.getContent().transformToLower());
            }
            this.tokenizer.setText(data, currentOffset);
            while (null != (token = this.tokenizer.nextToken())) {
                if (token.length() > 2048) {
                    LOG.warn((Object)("Token length exceeded 2048: " + token.getText().substring(0, 20) + "..."));
                    continue;
                }
                if (this.stoplist.contains(token) || indexSpec != null && !indexSpec.getIncludeAlphaNum() && !token.isAlpha()) continue;
                if (indexingHint == TEXT_BY_QNAME) {
                    this.invertedIndex.addText(token, (ElementImpl)parent, remove);
                    continue;
                }
                this.invertedIndex.addText(token, parent.getNodeId(), remove);
            }
        }
    }

    public void storeText(TextImpl node, NodePath currentPath, int indexingHint) {
    }

    public void removeNode(StoredNode node, NodePath currentPath, String content) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Lock lock = this.dbTokens.getLock();
        try {
            lock.acquire(1);
            this.dbTokens.flush();
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
        }
        catch (DBException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    public void flush() {
        this.invertedIndex.flush();
    }

    public void remove() {
        this.invertedIndex.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Collection collection) {
        Lock lock = this.dbTokens.getLock();
        try {
            lock.acquire(1);
            Value value = new WordRef(collection.getId());
            this.dbTokens.removeAll(null, new IndexQuery(7, value));
            value = new QNameWordRef(collection.getId());
            this.dbTokens.removeAll(null, new IndexQuery(7, value));
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    public void dropIndex(DocumentImpl document) {
        this.invertedIndex.dropIndex(document);
    }

    public NodeSet getNodesContaining(XQueryContext context, DocumentSet docs, NodeSet contextSet, int axis, QName qname, String expr, int type, boolean matchAll) throws TerminatedException {
        if (type == 0 && NativeTextEngine.containsWildcards(expr)) {
            type = 2;
        }
        switch (type) {
            case 0: {
                return this.getNodesExact(context, docs, contextSet, axis, qname, expr);
            }
        }
        return this.getNodesRegexp(context, docs, contextSet, axis, qname, expr, type, matchAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet getNodesExact(XQueryContext context, DocumentSet docs, NodeSet contextSet, int axis, QName qname, String expr) throws TerminatedException {
        if (expr == null) {
            return null;
        }
        if (this.stoplist.contains(expr)) {
            return null;
        }
        expr = expr.toLowerCase();
        String token = this.stem ? this.stemmer.stem(expr) : expr;
        ExtArrayNodeSet result = new ExtArrayNodeSet(docs.getLength(), 250);
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            int collectionId = ((Collection)iter.next()).getId();
            Value key = qname == null ? new WordRef(collectionId, token) : new QNameWordRef(collectionId, qname, token, this.broker.getBrokerPool().getSymbols());
            Lock lock = this.dbTokens.getLock();
            try {
                lock.acquire(0);
                VariableByteInput is = this.dbTokens.getAsStream(key);
                if (is == null) continue;
                while (is.available() > 0) {
                    int storedDocId = is.readInt();
                    byte storedSection = is.readByte();
                    int gidsCount = is.readInt();
                    int length = is.readFixedInt();
                    DocumentImpl storedDocument = docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes(length);
                        continue;
                    }
                    NodeId previous = null;
                    for (int m = 0; m < gidsCount; ++m) {
                        NodeProxy storedNode;
                        NodeId nodeId;
                        previous = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        int freq = is.readInt();
                        switch (storedSection) {
                            case 1: {
                                storedNode = new NodeProxy(storedDocument, nodeId, 2);
                                break;
                            }
                            case 0: {
                                storedNode = new NodeProxy(storedDocument, nodeId, 3);
                                break;
                            }
                            case 2: {
                                storedNode = new NodeProxy(storedDocument, nodeId, qname.getNameType() == 1 ? (short)2 : 1);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid section type in '" + this.dbTokens.getFile().getName() + "'");
                            }
                        }
                        if (contextSet != null) {
                            NodeProxy parent;
                            switch (storedSection) {
                                case 1: {
                                    if (contextSet instanceof VirtualNodeSet) {
                                        parent = contextSet.parentWithChild(storedNode, false, true, -1);
                                        if (parent == null || parent.getNodeId().equals(storedNode.getNodeId())) break;
                                        parent = null;
                                        break;
                                    }
                                    parent = contextSet.get(storedNode);
                                    break;
                                }
                                case 0: 
                                case 2: {
                                    parent = contextSet.parentWithChild(storedNode, false, true, -1);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Invalid section type in '" + this.dbTokens.getFile().getName() + "'");
                                }
                            }
                            if (parent != null) {
                                int sizeHint;
                                FTMatch match = new FTMatch(-1, nodeId, token, freq);
                                this.readOccurrences(freq, is, match, token.length());
                                if (axis == 0) {
                                    parent.addMatch(match);
                                    sizeHint = contextSet.getSizeHint(storedDocument);
                                    result.add(parent, sizeHint);
                                } else {
                                    storedNode.addMatch(match);
                                    sizeHint = contextSet.getSizeHint(storedDocument);
                                    result.add(storedNode, sizeHint);
                                }
                            } else {
                                is.skip(freq);
                            }
                        } else {
                            FTMatch match = new FTMatch(-1, nodeId, token, freq);
                            this.readOccurrences(freq, is, match, token.length());
                            storedNode.addMatch(match);
                            result.add(storedNode, -1);
                        }
                        context.proceed();
                    }
                }
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)(e.getMessage() + " in '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        return result;
    }

    private NodeSet getNodesRegexp(XQueryContext context, DocumentSet docs, NodeSet contextSet, int axis, QName qname, String expr, int type, boolean matchAll) throws TerminatedException {
        if (expr == null) {
            return null;
        }
        if (this.stoplist.contains(expr)) {
            return null;
        }
        expr = expr.toLowerCase();
        CharSequence start = "";
        if (matchAll) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < expr.length() && Character.isLetterOrDigit(expr.charAt(i)); ++i) {
                buf.append(expr.charAt(i));
            }
            start = buf;
        }
        try {
            RegexMatcher comparator = new RegexMatcher(expr, type, 66, matchAll);
            return this.getNodes(context, docs, contextSet, axis, qname, comparator, start);
        }
        catch (EXistException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet getNodes(XQueryContext context, DocumentSet docs, NodeSet contextSet, int axis, QName qname, TermMatcher matcher, CharSequence startTerm) throws TerminatedException {
        if (LOG.isTraceEnabled() && qname != null) {
            LOG.trace((Object)("Index lookup by QName: " + qname));
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        SearchCallback cb = new SearchCallback(context, matcher, result, contextSet, axis, docs, qname);
        Lock lock = this.dbTokens.getLock();
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            int collectionId = ((Collection)iter.next()).getId();
            Value value = startTerm != null && startTerm.length() > 0 ? (qname == null ? new WordRef(collectionId, ((Object)startTerm).toString().toLowerCase()) : new QNameWordRef(collectionId, qname, ((Object)startTerm).toString().toLowerCase(), this.broker.getBrokerPool().getSymbols())) : (qname == null ? new WordRef(collectionId) : new QNameWordRef(collectionId, qname, this.broker.getBrokerPool().getSymbols()));
            IndexQuery query = new IndexQuery(7, value);
            try {
                lock.acquire(0);
                this.dbTokens.query(query, cb);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexTerms(DocumentSet docs, TermMatcher matcher) {
        IndexCallback cb = new IndexCallback(null, matcher);
        Lock lock = this.dbTokens.getLock();
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            int collectionId = ((Collection)iter.next()).getId();
            WordRef value = new WordRef(collectionId);
            IndexQuery query = new IndexQuery(7, (Value)value);
            try {
                lock.acquire(0);
                this.dbTokens.query(query, cb);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (TerminatedException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        return cb.getMatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrences[] scanIndexTerms(DocumentSet docs, NodeSet contextSet, String start, String end) throws PermissionDeniedException {
        IndexScanCallback cb = new IndexScanCallback(docs, contextSet, false);
        Lock lock = this.dbTokens.getLock();
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            IndexQuery query;
            WordRef startRef;
            int collectionId = ((Collection)i.next()).getId();
            if (start == null) {
                startRef = new WordRef(collectionId);
                query = new IndexQuery(7, (Value)startRef);
            } else if (end == null) {
                startRef = new WordRef(collectionId, start.toLowerCase());
                query = new IndexQuery(7, (Value)startRef);
            } else {
                startRef = new WordRef(collectionId, start.toLowerCase());
                WordRef endRef = new WordRef(collectionId, end.toLowerCase());
                query = new IndexQuery(4, startRef, endRef);
            }
            try {
                lock.acquire(0);
                this.dbTokens.query(query, cb);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (TerminatedException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        Occurrences[] result = new Occurrences[cb.map.size()];
        return cb.map.values().toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrences[] scanIndexTerms(DocumentSet docs, NodeSet contextSet, QName[] qnames, String start, String end) throws PermissionDeniedException {
        Lock lock = this.dbTokens.getLock();
        IndexScanCallback cb = new IndexScanCallback(docs, contextSet, true);
        for (int q = 0; q < qnames.length; ++q) {
            Iterator i = docs.getCollectionIterator();
            while (i.hasNext()) {
                IndexQuery query;
                QNameWordRef startRef;
                int collectionId = ((Collection)i.next()).getId();
                if (start == null) {
                    startRef = new QNameWordRef(collectionId, qnames[q], this.broker.getBrokerPool().getSymbols());
                    query = new IndexQuery(7, (Value)startRef);
                } else if (end == null) {
                    startRef = new QNameWordRef(collectionId, qnames[q], start.toLowerCase(), this.broker.getBrokerPool().getSymbols());
                    query = new IndexQuery(7, (Value)startRef);
                } else {
                    startRef = new QNameWordRef(collectionId, qnames[q], start.toLowerCase(), this.broker.getBrokerPool().getSymbols());
                    QNameWordRef endRef = new QNameWordRef(collectionId, qnames[q], end.toLowerCase(), this.broker.getBrokerPool().getSymbols());
                    query = new IndexQuery(4, startRef, endRef);
                }
                try {
                    lock.acquire(0);
                    this.dbTokens.query(query, cb);
                }
                catch (LockException e) {
                    LOG.warn((Object)("Failed to acquire lock for '" + this.dbTokens.getFile().getName() + "'"), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BTreeException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (TerminatedException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(0);
                }
            }
        }
        Occurrences[] result = new Occurrences[cb.map.size()];
        return cb.map.values().toArray(result);
    }

    private void readOccurrences(int freq, VariableByteInput is, Match match, int length) throws IOException {
        for (int n = 0; n < freq; ++n) {
            match.addOffset(is.readInt(), length);
        }
    }

    private void collect(Set words, Iterator domIterator) {
        byte[] data = ((Value)domIterator.next()).getData();
        short type = Signatures.getType(data[0]);
        switch (type) {
            case 1: {
                int childrenCount = ByteConversion.byteToInt(data, 1);
                for (int i = 0; i < childrenCount; ++i) {
                    this.collect(words, domIterator);
                }
                break;
            }
            case 3: {
                short dlnLen = ByteConversion.byteToShort(data, 1);
                int nodeIdLen = this.broker.getBrokerPool().getNodeFactory().lengthInBytes(dlnLen, data, 3);
                try {
                    TextToken token;
                    int readOffset = nodeIdLen + 3;
                    String s = new String(data, readOffset, data.length - readOffset, "UTF-8");
                    this.tokenizer.setText(s);
                    while (null != (token = this.tokenizer.nextToken())) {
                        String word = token.getText();
                        if (this.stoplist.contains(word)) continue;
                        words.add(word.toLowerCase());
                    }
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    break;
                }
            }
            case 2: {
                byte idSizeType = (byte)(data[0] & 3);
                boolean hasNamespace = (data[0] & 0x10) == 16;
                short dlnLen = ByteConversion.byteToShort(data, 1);
                int nodeIdLen = this.broker.getBrokerPool().getNodeFactory().lengthInBytes(dlnLen, data, 3);
                int readOffset = Signatures.getLength(idSizeType) + nodeIdLen + 3;
                if (hasNamespace) {
                    short prefixLen = ByteConversion.byteToShort(data, readOffset += SymbolTable.LENGTH_LOCAL_NAME);
                    readOffset += prefixLen + SymbolTable.LENGTH_NS_URI;
                }
                try {
                    TextToken token;
                    String val = new String(data, readOffset, data.length - readOffset, "UTF-8");
                    this.tokenizer.setText(val);
                    while (null != (token = this.tokenizer.nextToken())) {
                        String word = token.getText();
                        if (this.stoplist.contains(word)) continue;
                        words.add(word.toLowerCase());
                    }
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    break;
                }
            }
        }
    }

    public void closeAndRemove() {
        this.config.setProperty(this.getConfigKeyForFile(), null);
        this.dbTokens.closeAndRemove();
    }

    public boolean close() throws DBException {
        this.config.setProperty(this.getConfigKeyForFile(), null);
        return this.dbTokens.close();
    }

    public void printStatistics() {
        this.dbTokens.printStatistics();
    }

    public String toString() {
        return this.getClass().getName() + " at " + this.dbTokens.getFile().getName() + " owned by " + this.broker.toString();
    }

    private static final class QNameWordRef
    extends Value {
        public static int LENGTH_IDX_TYPE = 1;
        public static int LENGTH_QNAME_TYPE = 1;
        public static int OFFSET_IDX_TYPE = 0;
        public static int OFFSET_COLLECTION_ID = OFFSET_IDX_TYPE + LENGTH_IDX_TYPE;
        public static int OFFSET_QNAME_TYPE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
        public static int OFFSET_NS_URI = OFFSET_QNAME_TYPE + LENGTH_QNAME_TYPE;
        public static int OFFSET_LOCAL_NAME = OFFSET_NS_URI + SymbolTable.LENGTH_NS_URI;
        public static int OFFSET_WORD = OFFSET_LOCAL_NAME + SymbolTable.LENGTH_LOCAL_NAME;

        public QNameWordRef(int collectionId) {
            this.len = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID;
            this.data = new byte[this.len];
            this.data[QNameWordRef.OFFSET_IDX_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.pos = OFFSET_IDX_TYPE;
        }

        public QNameWordRef(int collectionId, QName qname, SymbolTable symbols) {
            this.len = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID + LENGTH_QNAME_TYPE + SymbolTable.LENGTH_NS_URI + SymbolTable.LENGTH_LOCAL_NAME;
            this.data = new byte[this.len];
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalName());
            this.data[QNameWordRef.OFFSET_IDX_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.data[QNameWordRef.OFFSET_QNAME_TYPE] = qname.getNameType();
            ByteConversion.shortToByte(namespaceId, this.data, OFFSET_NS_URI);
            ByteConversion.shortToByte(localNameId, this.data, OFFSET_LOCAL_NAME);
        }

        public QNameWordRef(int collectionId, QName qname, String word, SymbolTable symbols) {
            this.len = UTF8.encoded(word) + LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID + LENGTH_QNAME_TYPE + SymbolTable.LENGTH_NS_URI + SymbolTable.LENGTH_LOCAL_NAME;
            this.data = new byte[this.len];
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalName());
            this.data[QNameWordRef.OFFSET_IDX_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.data[QNameWordRef.OFFSET_QNAME_TYPE] = qname.getNameType();
            ByteConversion.shortToByte(namespaceId, this.data, OFFSET_NS_URI);
            ByteConversion.shortToByte(localNameId, this.data, OFFSET_LOCAL_NAME);
            UTF8.encode(word, this.data, OFFSET_WORD);
        }

        public static XMLString decode(Value key, XMLString word) {
            int prefixLength = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID + LENGTH_QNAME_TYPE + SymbolTable.LENGTH_NS_URI + SymbolTable.LENGTH_LOCAL_NAME;
            return UTF8.decode(key.getData(), prefixLength, key.getLength() - prefixLength, word);
        }

        public String toString() {
            if (this.len > OFFSET_WORD) {
                return new String(this.data, OFFSET_WORD, this.len - OFFSET_WORD);
            }
            return "no word";
        }
    }

    private static final class WordRef
    extends Value {
        public static int LENGTH_IDX_TYPE = 1;
        public static int OFFSET_IDX_TYPE = 0;
        public static int OFFSET_COLLECTION_ID = OFFSET_IDX_TYPE + LENGTH_IDX_TYPE;
        public static int OFFSET_WORD = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;

        public WordRef(int collectionId) {
            this.len = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID;
            this.data = new byte[this.len];
            this.data[WordRef.OFFSET_IDX_TYPE] = 0;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
        }

        public WordRef(int collectionId, String word) {
            this.len = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID + UTF8.encoded(word);
            this.data = new byte[this.len];
            this.data[WordRef.OFFSET_IDX_TYPE] = 0;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            UTF8.encode(word, this.data, OFFSET_WORD);
        }

        public static XMLString decode(Value key, XMLString word) {
            int prefixLength = LENGTH_IDX_TYPE + Collection.LENGTH_COLLECTION_ID;
            return UTF8.decode(key.getData(), prefixLength, key.getLength() - prefixLength, word);
        }

        public String toString() {
            if (this.len > OFFSET_WORD) {
                return new String(this.data, OFFSET_WORD, this.len - OFFSET_WORD);
            }
            return "no word";
        }
    }

    private static class TermFrequencyList {
        private TermFreq first = null;
        private TermFreq last = null;
        private int count = 0;

        private TermFrequencyList() {
        }

        public void add(long l) {
            if (this.first == null) {
                this.last = this.first = new TermFreq(l);
            } else {
                TermFreq next;
                this.last.next = next = new TermFreq(l);
                this.last = next;
            }
            ++this.count;
        }

        public void incLastTerm() {
            if (this.last != null) {
                this.last.increment();
            }
        }

        public void setLastTermFreq(int freq) {
            if (this.last != null) {
                this.last.count = freq;
            }
        }

        public long getLast() {
            if (this.last != null) {
                return this.last.l;
            }
            return -1L;
        }

        public boolean contains(long l) {
            TermFreq next = this.first;
            while (next != null) {
                if (next.l == l) {
                    return true;
                }
                next = next.next;
            }
            return false;
        }

        public int getSize() {
            return this.count;
        }

        public TermFreq[] toArray() {
            TermFreq[] data = new TermFreq[this.count];
            TermFreq next = this.first;
            int i = 0;
            while (next != null) {
                data[i++] = next;
                next = next.next;
            }
            return data;
        }

        protected static class TermFreq
        implements Comparable {
            long l;
            int count = 1;
            TermFreq next = null;

            public TermFreq(long l) {
                this.l = l;
            }

            public void increment() {
                ++this.count;
            }

            public int compareTo(Object o) {
                TermFreq other = (TermFreq)o;
                if (this.l == other.l) {
                    return 0;
                }
                return this.l < other.l ? -1 : 1;
            }
        }
    }

    private final class IndexScanCallback
    implements BTreeCallback {
        private DocumentSet docs;
        private NodeSet contextSet;
        private Map map = new TreeMap();
        private XMLString word = new XMLString(64);
        private boolean byQName;

        IndexScanCallback(DocumentSet docs, NodeSet contextSet, boolean byQName) {
            this.docs = docs;
            this.contextSet = contextSet;
            this.byQName = byQName;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            VariableByteInput is;
            this.word.reuse();
            if (this.byQName) {
                QNameWordRef.decode(key, this.word);
            } else {
                WordRef.decode(key, this.word);
            }
            String term = this.word.toString();
            try {
                is = NativeTextEngine.this.dbTokens.getAsStream(pointer);
            }
            catch (IOException e) {
                TextSearchEngine.LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                while (is.available() > 0) {
                    boolean docAdded = false;
                    int storedDocId = is.readInt();
                    byte storedSection = is.readByte();
                    int termCount = is.readInt();
                    int length = is.readFixedInt();
                    DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes(length);
                        continue;
                    }
                    NodeId previous = null;
                    for (int m = 0; m < termCount; ++m) {
                        NodeId nodeId;
                        previous = nodeId = NativeTextEngine.this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        int freq = is.readInt();
                        is.skip(freq);
                        if (this.contextSet == null) continue;
                        boolean include = false;
                        NodeProxy parentNode = this.contextSet.parentWithChild(storedDocument, nodeId, false, true);
                        switch (storedSection) {
                            case 0: 
                            case 2: {
                                include = parentNode != null;
                                break;
                            }
                            case 1: {
                                include = parentNode != null && parentNode.getNodeType() == 2;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid section type  in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'");
                            }
                        }
                        if (!include) continue;
                        Occurrences oc = (Occurrences)this.map.get(term);
                        if (oc == null) {
                            oc = new Occurrences((Comparable)((Object)term));
                            this.map.put(term, oc);
                        }
                        if (!docAdded) {
                            oc.addDocument(storedDocument);
                            docAdded = true;
                        }
                        oc.addOccurrences(freq);
                    }
                }
            }
            catch (IOException e) {
                TextSearchEngine.LOG.error((Object)(e.getMessage() + " in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'"), (Throwable)e);
            }
            return true;
        }
    }

    private final class SearchCallback
    implements BTreeCallback {
        DocumentSet docs;
        TermMatcher matcher;
        NodeSet result;
        NodeSet contextSet;
        int axis;
        XQueryContext context;
        XMLString word = new XMLString(64);
        QName qname;

        public SearchCallback(XQueryContext context, TermMatcher comparator, NodeSet result, NodeSet contextSet, int axis, DocumentSet docs, QName qname) {
            this.matcher = comparator;
            this.result = result;
            this.docs = docs;
            this.contextSet = contextSet;
            this.context = context;
            this.qname = qname;
            this.axis = axis;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            VariableByteInput is;
            try {
                is = NativeTextEngine.this.dbTokens.getAsStream(pointer);
            }
            catch (IOException e) {
                TextSearchEngine.LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            this.word.reuse();
            if (this.qname == null) {
                WordRef.decode(key, this.word);
            } else {
                QNameWordRef.decode(key, this.word);
            }
            if (this.matcher.matches(this.word)) {
                try {
                    while (is.available() > 0) {
                        if (this.context != null) {
                            this.context.proceed();
                        }
                        int storedDocId = is.readInt();
                        byte storedSection = is.readByte();
                        int termCount = is.readInt();
                        int length = is.readFixedInt();
                        DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                        if (storedDocument == null) {
                            is.skipBytes(length);
                            continue;
                        }
                        NodeId previous = null;
                        for (int m = 0; m < termCount; ++m) {
                            NodeProxy storedNode;
                            NodeId nodeId;
                            previous = nodeId = NativeTextEngine.this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                            int freq = is.readInt();
                            switch (storedSection) {
                                case 0: {
                                    storedNode = new NodeProxy(storedDocument, nodeId, 3);
                                    break;
                                }
                                case 1: {
                                    storedNode = new NodeProxy(storedDocument, nodeId, 2);
                                    break;
                                }
                                case 2: {
                                    storedNode = new NodeProxy(storedDocument, nodeId, this.qname.getNameType() == 1 ? (short)2 : 1);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Invalid section type in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'");
                                }
                            }
                            if (this.contextSet != null) {
                                NodeProxy parentNode;
                                switch (storedSection) {
                                    case 0: 
                                    case 2: {
                                        parentNode = this.contextSet.parentWithChild(storedNode, false, true, -1);
                                        break;
                                    }
                                    case 1: {
                                        if (this.contextSet instanceof VirtualNodeSet) {
                                            parentNode = this.contextSet.parentWithChild(storedNode, false, true, -1);
                                            if (parentNode == null || !parentNode.getNodeId().equals(nodeId)) break;
                                            parentNode = null;
                                            break;
                                        }
                                        parentNode = this.contextSet.get(storedNode);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Invalid section type in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'");
                                    }
                                }
                                if (parentNode != null) {
                                    FTMatch match = new FTMatch(-1, nodeId, this.word.toString(), freq);
                                    NativeTextEngine.this.readOccurrences(freq, is, match, this.word.length());
                                    int sizeHint = this.contextSet.getSizeHint(storedDocument);
                                    if (this.axis == 0) {
                                        parentNode.addMatch(match);
                                        this.result.add(parentNode, sizeHint);
                                        continue;
                                    }
                                    storedNode.addMatch(match);
                                    this.result.add(storedNode, sizeHint);
                                    continue;
                                }
                                is.skip(freq);
                                continue;
                            }
                            FTMatch match = new FTMatch(-1, nodeId, this.word.toString(), freq);
                            NativeTextEngine.this.readOccurrences(freq, is, match, this.word.length());
                            storedNode.addMatch(match);
                            this.result.add(storedNode, -1);
                        }
                    }
                }
                catch (IOException e) {
                    TextSearchEngine.LOG.error((Object)(e.getMessage() + " in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'"), (Throwable)e);
                }
            }
            if (this.contextSet != null) {
                ((ExtArrayNodeSet)this.result).sort();
            }
            return true;
        }
    }

    private class IndexCallback
    implements BTreeCallback {
        List matches = new ArrayList();
        TermMatcher matcher;
        XQueryContext context;

        public IndexCallback(XQueryContext context, TermMatcher matcher) {
            this.matcher = matcher;
            this.context = context;
        }

        public String[] getMatches() {
            String[] a = new String[this.matches.size()];
            return this.matches.toArray(a);
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            if (this.context != null) {
                this.context.proceed();
            }
            try {
                String word = new String(key.getData(), Collection.LENGTH_COLLECTION_ID, key.getLength() - Collection.LENGTH_COLLECTION_ID, "UTF-8");
                if (this.matcher.matches(word)) {
                    this.matches.add(word);
                }
                return true;
            }
            catch (UnsupportedEncodingException e) {
                TextSearchEngine.LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
        }
    }

    final class InvertedIndex {
        private DocumentImpl doc = null;
        private Map[] words = new Map[3];
        private int TEXT_NODES = 0;
        private int ATTRIBUTE_NODES = 1;
        private int BY_QNAME = 2;

        public InvertedIndex() {
            this.words[this.TEXT_NODES] = new HashMap(512);
            this.words[this.ATTRIBUTE_NODES] = new HashMap(256);
            this.words[this.BY_QNAME] = new TreeMap();
        }

        public void setDocument(DocumentImpl document) {
            if (this.doc != null && this.doc.getDocId() != document.getDocId()) {
                this.flush();
            }
            this.doc = document;
        }

        public void addText(TextToken token, NodeId nodeId, boolean remove) {
            if (!remove) {
                OccurrenceList list = (OccurrenceList)this.words[this.TEXT_NODES].get(token);
                if (list == null) {
                    list = new OccurrenceList();
                    list.add(nodeId, token.startOffset());
                    this.words[this.TEXT_NODES].put(token.getText(), list);
                } else {
                    list.add(nodeId, token.startOffset());
                }
            } else if (!this.words[this.TEXT_NODES].containsKey(token)) {
                this.words[this.TEXT_NODES].put(token, null);
            }
        }

        public void addText(TextToken token, ElementImpl ancestor, boolean remove) {
            QNameTerm term = new QNameTerm(ancestor.getQName(), token.getText());
            if (!remove) {
                OccurrenceList list = (OccurrenceList)this.words[this.BY_QNAME].get(term);
                if (list == null) {
                    list = new OccurrenceList();
                    list.add(ancestor.getNodeId(), token.startOffset());
                    this.words[this.BY_QNAME].put(term, list);
                } else {
                    list.add(ancestor.getNodeId(), token.startOffset());
                }
            } else if (!this.words[this.BY_QNAME].containsKey(term)) {
                this.words[this.BY_QNAME].put(term, null);
            }
        }

        public void addAttribute(TextToken token, NodeId nodeId, boolean remove) {
            if (!remove) {
                OccurrenceList list = (OccurrenceList)this.words[this.ATTRIBUTE_NODES].get(token);
                if (list == null) {
                    list = new OccurrenceList();
                    list.add(nodeId, token.startOffset());
                    this.words[this.ATTRIBUTE_NODES].put(token.getText(), list);
                } else {
                    list.add(nodeId, token.startOffset());
                }
            } else if (!this.words[this.ATTRIBUTE_NODES].containsKey(token)) {
                this.words[this.ATTRIBUTE_NODES].put(token, null);
            }
        }

        public void addAttribute(TextToken token, AttrImpl attr, boolean remove) {
            QNameTerm term = new QNameTerm(attr.getQName(), token.getText());
            if (!remove) {
                OccurrenceList list = (OccurrenceList)this.words[this.BY_QNAME].get(term);
                if (list == null) {
                    list = new OccurrenceList();
                    list.add(attr.getNodeId(), token.startOffset());
                    this.words[this.BY_QNAME].put(term, list);
                } else {
                    list.add(attr.getNodeId(), token.startOffset());
                }
            } else if (!this.words[this.BY_QNAME].containsKey(term)) {
                this.words[this.BY_QNAME].put(term, null);
            }
        }

        public void flush() {
            if (this.doc == null) {
                return;
            }
            int wordsCount = this.words[this.TEXT_NODES].size() + this.words[this.ATTRIBUTE_NODES].size() + this.words[this.BY_QNAME].size();
            if (wordsCount == 0) {
                return;
            }
            ProgressIndicator progress = new ProgressIndicator(wordsCount, 100);
            int collectionId = this.doc.getCollection().getId();
            int count = 0;
            for (byte currentSection = 0; currentSection <= 2; currentSection = (byte)((byte)(currentSection + 1))) {
                switch (currentSection) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid section type in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)");
                    }
                }
                Iterator i = this.words[currentSection].entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object token = entry.getKey();
                    OccurrenceList occurences = (OccurrenceList)entry.getValue();
                    if (occurences != null) {
                        int freq;
                        occurences.sort();
                        NativeTextEngine.this.os.clear();
                        NativeTextEngine.this.os.writeInt(this.doc.getDocId());
                        NativeTextEngine.this.os.writeByte(currentSection);
                        NativeTextEngine.this.os.writeInt(occurences.getTermCount());
                        int lenOffset = NativeTextEngine.this.os.position();
                        NativeTextEngine.this.os.writeFixedInt(0);
                        NodeId previous = null;
                        for (int m = 0; m < occurences.getSize(); m += freq) {
                            try {
                                previous = occurences.getNode(m).write(previous, NativeTextEngine.this.os);
                            }
                            catch (IOException e) {
                                TextSearchEngine.LOG.error((Object)("IOException while writing fulltext index: " + e.getMessage()), (Throwable)e);
                            }
                            freq = occurences.getOccurrences(m);
                            NativeTextEngine.this.os.writeInt(freq);
                            for (int n = 0; n < freq; ++n) {
                                NativeTextEngine.this.os.writeInt(occurences.getOffset(m + n));
                            }
                        }
                        NativeTextEngine.this.os.writeFixedInt(lenOffset, NativeTextEngine.this.os.position() - lenOffset - 4);
                        this.flushWord(currentSection, collectionId, token, NativeTextEngine.this.os.data());
                        progress.setValue(count);
                        if (progress.changed()) {
                            NativeTextEngine.this.setChanged();
                            NativeTextEngine.this.notifyObservers(progress);
                        }
                    }
                    ++count;
                }
                if (wordsCount > 100) {
                    progress.finish();
                    NativeTextEngine.this.setChanged();
                    NativeTextEngine.this.notifyObservers(progress);
                }
                this.words[currentSection].clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushWord(int currentSection, int collectionId, Object token, ByteArray data) {
            if (data.size() == 0) {
                return;
            }
            Lock lock = NativeTextEngine.this.dbTokens.getLock();
            try {
                Value key;
                lock.acquire(1);
                if (currentSection == 2) {
                    QNameTerm term = (QNameTerm)token;
                    key = new QNameWordRef(collectionId, term.qname, term.term, NativeTextEngine.this.broker.getBrokerPool().getSymbols());
                } else {
                    key = new WordRef(collectionId, token.toString());
                }
                NativeTextEngine.this.dbTokens.append(key, data);
            }
            catch (LockException e) {
                TextSearchEngine.LOG.warn((Object)("Failed to acquire lock for '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)"), (Throwable)e);
            }
            catch (ReadOnlyException e) {
                TextSearchEngine.LOG.warn((Object)("Read-only error on '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)"), (Throwable)e);
            }
            catch (IOException e) {
                TextSearchEngine.LOG.error((Object)(e.getMessage() + "' in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)"), (Throwable)e);
            }
            finally {
                lock.release(1);
                NativeTextEngine.this.os.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dropIndex(DocumentImpl document) {
            if (document == null) {
                return;
            }
            int collectionId = document.getCollection().getId();
            Lock lock = NativeTextEngine.this.dbTokens.getLock();
            for (int currentSection = 0; currentSection <= 2; currentSection = (int)((byte)(currentSection + 1))) {
                switch (currentSection) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid section type in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)");
                    }
                }
                TextSearchEngine.LOG.debug((Object)("Removing " + this.words[currentSection].size() + " tokens"));
                Iterator i = this.words[currentSection].entrySet().iterator();
                while (i.hasNext()) {
                    Value key;
                    Map.Entry entry = i.next();
                    Object token = entry.getKey();
                    if (currentSection == 2) {
                        QNameTerm term = (QNameTerm)token;
                        key = new QNameWordRef(collectionId, term.qname, term.term, NativeTextEngine.this.broker.getBrokerPool().getSymbols());
                    } else {
                        key = new WordRef(collectionId, token.toString());
                    }
                    NativeTextEngine.this.os.clear();
                    try {
                        lock.acquire(1);
                        boolean changed = false;
                        NativeTextEngine.this.os.clear();
                        VariableByteInput is = NativeTextEngine.this.dbTokens.getAsStream(key);
                        if (is == null) continue;
                        while (is.available() > 0) {
                            int storedDocId = is.readInt();
                            byte section = is.readByte();
                            int gidsCount = is.readInt();
                            int length = is.readFixedInt();
                            if (storedDocId != document.getDocId()) {
                                NativeTextEngine.this.os.writeInt(storedDocId);
                                NativeTextEngine.this.os.writeByte(section);
                                NativeTextEngine.this.os.writeInt(gidsCount);
                                NativeTextEngine.this.os.writeFixedInt(length);
                                is.copyRaw(NativeTextEngine.this.os, length);
                                continue;
                            }
                            changed = true;
                            is.skipBytes(length);
                        }
                        if (!changed) continue;
                        if (NativeTextEngine.this.os.data().size() == 0) {
                            NativeTextEngine.this.dbTokens.remove(key);
                            continue;
                        }
                        if (NativeTextEngine.this.dbTokens.put(key, NativeTextEngine.this.os.data()) != -1L) continue;
                        TextSearchEngine.LOG.error((Object)("Could not put index data for token '" + token + "' in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'"));
                    }
                    catch (LockException e) {
                        TextSearchEngine.LOG.warn((Object)("Failed to acquire lock for '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'"), (Throwable)e);
                    }
                    catch (IOException e) {
                        TextSearchEngine.LOG.error((Object)(e.getMessage() + " in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'"), (Throwable)e);
                    }
                    catch (ReadOnlyException e) {
                        TextSearchEngine.LOG.error((Object)(e.getMessage() + " in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "'"), (Throwable)e);
                    }
                    finally {
                        lock.release(1);
                        NativeTextEngine.this.os.clear();
                    }
                }
                this.words[currentSection].clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.doc == null) {
                return;
            }
            int collectionId = this.doc.getCollection().getId();
            Lock lock = NativeTextEngine.this.dbTokens.getLock();
            for (byte currentSection = 0; currentSection <= 2; currentSection = (byte)((byte)(currentSection + 1))) {
                switch (currentSection) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid section type in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)");
                    }
                }
                Iterator i = this.words[currentSection].entrySet().iterator();
                while (i.hasNext()) {
                    Value key;
                    Map.Entry entry = i.next();
                    OccurrenceList storedOccurencesList = (OccurrenceList)entry.getValue();
                    Object token = entry.getKey();
                    if (currentSection == 2) {
                        QNameTerm term = (QNameTerm)token;
                        key = new QNameWordRef(collectionId, term.qname, term.term, NativeTextEngine.this.broker.getBrokerPool().getSymbols());
                    } else {
                        key = new WordRef(collectionId, token.toString());
                    }
                    OccurrenceList newOccurencesList = new OccurrenceList();
                    NativeTextEngine.this.os.clear();
                    try {
                        lock.acquire(1);
                        Value value = NativeTextEngine.this.dbTokens.get(key);
                        if (value == null) continue;
                        VariableByteArrayInput is = new VariableByteArrayInput(value.getData());
                        while (is.available() > 0) {
                            int storedDocId = is.readInt();
                            byte storedSection = is.readByte();
                            int termCount = is.readInt();
                            int length = is.readFixedInt();
                            if (storedSection != currentSection || storedDocId != this.doc.getDocId()) {
                                NativeTextEngine.this.os.writeInt(storedDocId);
                                NativeTextEngine.this.os.writeByte(storedSection);
                                NativeTextEngine.this.os.writeInt(termCount);
                                NativeTextEngine.this.os.writeFixedInt(length);
                                is.copyRaw(NativeTextEngine.this.os, length);
                                continue;
                            }
                            NodeId previous = null;
                            for (int m = 0; m < termCount; ++m) {
                                NodeId nodeId;
                                previous = nodeId = NativeTextEngine.this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                                int freq = is.readInt();
                                if (!storedOccurencesList.contains(nodeId)) {
                                    for (int n = 0; n < freq; ++n) {
                                        newOccurencesList.add(nodeId, is.readInt());
                                    }
                                    continue;
                                }
                                is.skip(freq);
                            }
                        }
                        if (newOccurencesList.getSize() > 0) {
                            int freq;
                            newOccurencesList.sort();
                            NativeTextEngine.this.os.writeInt(this.doc.getDocId());
                            NativeTextEngine.this.os.writeByte(currentSection);
                            NativeTextEngine.this.os.writeInt(newOccurencesList.getTermCount());
                            int lenOffset = NativeTextEngine.this.os.position();
                            NativeTextEngine.this.os.writeFixedInt(0);
                            NodeId previous = null;
                            for (int m = 0; m < newOccurencesList.getSize(); m += freq) {
                                previous = newOccurencesList.getNode(m).write(previous, NativeTextEngine.this.os);
                                freq = newOccurencesList.getOccurrences(m);
                                NativeTextEngine.this.os.writeInt(freq);
                                for (int n = 0; n < freq; ++n) {
                                    NativeTextEngine.this.os.writeInt(newOccurencesList.getOffset(m + n));
                                }
                            }
                            NativeTextEngine.this.os.writeFixedInt(lenOffset, NativeTextEngine.this.os.position() - lenOffset - 4);
                        }
                        if (NativeTextEngine.this.os.data().size() == 0) {
                            NativeTextEngine.this.dbTokens.remove(key);
                            continue;
                        }
                        if (NativeTextEngine.this.dbTokens.update(value.getAddress(), key, NativeTextEngine.this.os.data()) != -1L) continue;
                        TextSearchEngine.LOG.error((Object)("Could not update index data for token '" + token + "' in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)"));
                    }
                    catch (LockException e) {
                        TextSearchEngine.LOG.warn((Object)("Failed to acquire lock for '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)"), (Throwable)e);
                    }
                    catch (ReadOnlyException e) {
                        TextSearchEngine.LOG.warn((Object)("Read-only error on '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)"), (Throwable)e);
                    }
                    catch (IOException e) {
                        TextSearchEngine.LOG.error((Object)(e.getMessage() + "' in '" + NativeTextEngine.this.dbTokens.getFile().getName() + "' (inverted index)"), (Throwable)e);
                    }
                    finally {
                        lock.release(1);
                        NativeTextEngine.this.os.clear();
                    }
                }
                this.words[currentSection].clear();
            }
        }

        private class QNameTerm
        implements Comparable {
            QName qname;
            String term;

            public QNameTerm(QName qname, String term) {
                this.qname = qname;
                this.term = term;
            }

            public int compareTo(Object o) {
                QNameTerm other = (QNameTerm)o;
                int cmp = this.qname.compareTo(other.qname);
                if (cmp == 0) {
                    return this.term.compareTo(other.term);
                }
                return cmp;
            }
        }
    }
}

