/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.EXistException;
import org.exist.storage.TermMatcher;
import org.exist.util.GlobToRegex;

class RegexMatcher
implements TermMatcher {
    private Matcher matcher;
    private boolean matchAll = false;

    public RegexMatcher(String expr, int type, int flags) throws EXistException {
        this(expr, type, flags, false);
    }

    public RegexMatcher(String expr, int type, int flags, boolean matchAll) throws EXistException {
        try {
            if (type == 2) {
                expr = GlobToRegex.globToRegexp(expr);
                flags = 66;
            }
            Pattern pattern = Pattern.compile(expr, flags);
            this.matcher = pattern.matcher("");
        }
        catch (PatternSyntaxException e) {
            throw new EXistException("Invalid regular expression: " + e.getMessage());
        }
        this.matchAll = matchAll;
    }

    public boolean matches(CharSequence term) {
        this.matcher.reset(term);
        return this.matchAll ? this.matcher.matches() : this.matcher.find();
    }
}

