/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.storage.Indexable;
import org.exist.storage.ValueIndexKeyFactory;
import org.exist.util.ByteConversion;

public class ValueIndexKeyFactorySimple
implements ValueIndexKeyFactory {
    public static int OFFSET_COLLECTION_ID = 0;
    public static int OFFSET_VALUE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
    private Indexable indexable;

    public ValueIndexKeyFactorySimple(Indexable indexable) {
        this.indexable = indexable;
    }

    public byte[] serialize(short collectionId) throws EXistException {
        byte[] data = this.indexable.serializeValue(OFFSET_VALUE);
        ByteConversion.shortToByte(collectionId, data, OFFSET_COLLECTION_ID);
        return data;
    }

    public int compareTo(Object other) {
        int ret = 0;
        if (other instanceof ValueIndexKeyFactorySimple) {
            ValueIndexKeyFactorySimple otherIndexable = (ValueIndexKeyFactorySimple)other;
            ret = this.indexable.compareTo(otherIndexable.indexable);
        }
        return ret;
    }
}

