/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.GClockCache;

public class LRDCache
extends GClockCache {
    protected int totalReferences = 0;
    private int nextCleanup;
    private int maxReferences;
    private int ageingPeriod;

    public LRDCache(int size, double growthFactor, double growthThreshold, String type) {
        super(size, growthFactor, growthThreshold, type);
        this.maxReferences = size * 10000;
        this.ageingPeriod = size * 5000;
    }

    public void add(Cacheable item, int initialRefCount) {
        Cacheable old = (Cacheable)this.map.get(item.getKey());
        if (old != null) {
            old.incReferenceCount();
            ++this.totalReferences;
        } else {
            item.setReferenceCount(initialRefCount);
            item.setTimestamp(this.totalReferences);
            if (this.count < this.size) {
                this.items[this.count++] = item;
                this.map.put(item.getKey(), item);
                ++this.used;
            } else {
                this.removeOne(item);
            }
            this.totalReferences += initialRefCount;
        }
        if (this.totalReferences > this.maxReferences) {
            this.cleanup();
        } else if (this.totalReferences > this.nextCleanup) {
            this.ageReferences();
        }
    }

    protected Cacheable removeOne(Cacheable item) {
        Cacheable old;
        double rd = 0.0;
        double minRd = -1.0;
        int bucket = -1;
        int len = this.items.length;
        for (int i = 0; i < len; ++i) {
            old = this.items[i];
            if (old == null) {
                bucket = i;
                break;
            }
            rd = (double)old.getReferenceCount() / (double)(this.totalReferences - old.getTimestamp());
            if (!(minRd < 0.0) && !(rd < minRd) || !old.allowUnload()) continue;
            minRd = rd;
            bucket = i;
        }
        if (bucket < 0) {
            bucket = 0;
        }
        if ((old = this.items[bucket]) != null) {
            this.map.remove(old.getKey());
            old.sync(true);
        } else {
            ++this.used;
        }
        this.items[bucket] = item;
        this.map.put(item.getKey(), item);
        if (old != null) {
            this.accounting.replacedPage(item);
            if (this.cacheManager != null && this.accounting.resizeNeeded()) {
                this.cacheManager.requestMem(this);
            }
        }
        return old;
    }

    protected void ageReferences() {
        int limit = this.ageingPeriod / 10;
        for (int i = 0; i < this.count; ++i) {
            Cacheable item = this.items[i];
            if (item == null) continue;
            int refCount = item.getReferenceCount();
            if (refCount > limit) {
                item.setReferenceCount(refCount - limit);
                continue;
            }
            item.setReferenceCount(1);
        }
        this.nextCleanup += this.ageingPeriod;
    }

    protected void cleanup() {
        LOG.debug((Object)("totalReferences = " + this.totalReferences + "; maxReferences = " + this.maxReferences));
        this.totalReferences = this.count;
        for (int i = 0; i < this.count; ++i) {
            Cacheable item = this.items[i];
            if (item == null) continue;
            item.setReferenceCount(1);
            item.setTimestamp(1);
        }
        this.nextCleanup = this.totalReferences + this.ageingPeriod;
    }
}

