/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class InsertValueLoggable
extends AbstractLoggable {
    protected DOMFile domDb;
    protected byte isOverflow;
    protected long pageNum;
    protected short tid;
    protected byte[] value;
    protected int offset;

    public InsertValueLoggable(Txn transaction, long pageNum, boolean isOverflow, short tid, byte[] value, int offset) {
        super((byte)24, transaction.getId());
        this.pageNum = pageNum;
        this.isOverflow = isOverflow ? (byte)1 : 0;
        this.tid = tid;
        this.value = value;
        this.offset = offset;
    }

    public InsertValueLoggable(DBBroker broker, long transactionId) {
        super((byte)24, transactionId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    protected boolean isOverflow() {
        return this.isOverflow == 1;
    }

    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.put(this.isOverflow);
        out.putInt(this.offset);
        out.putShort(this.tid);
        out.putShort((short)this.value.length);
        out.put(this.value);
    }

    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.isOverflow = in.get();
        this.offset = in.getInt();
        this.tid = in.getShort();
        this.value = new byte[in.getShort()];
        in.get(this.value);
    }

    public int getLogSize() {
        return 13 + this.value.length;
    }

    public void redo() throws LogException {
        this.domDb.redoInsertValue(this);
    }

    public void undo() throws LogException {
        this.domDb.undoInsertValue(this);
    }

    public String dump() {
        return super.dump() + " - inserted value; tid = " + this.tid + " in page " + this.pageNum + "; bytes: " + this.value.length + "; offset: " + this.offset;
    }
}

