/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;
import org.exist.storage.io.AbstractVariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class VariableByteArrayInput
extends AbstractVariableByteInput {
    protected byte[] data;
    protected int position;
    protected int end;
    private static Logger LOG = Logger.getLogger((String)VariableByteArrayInput.class.getName());

    public VariableByteArrayInput() {
    }

    public VariableByteArrayInput(byte[] data) {
        this.data = data;
        this.position = 0;
        this.end = data.length;
    }

    public VariableByteArrayInput(byte[] data, int offset, int length) {
        this.data = data;
        this.position = offset;
        this.end = offset + length;
    }

    public void initialize(byte[] data, int offset, int length) {
        this.data = data;
        this.position = offset;
        this.end = offset + length;
    }

    public byte readByte() throws IOException, EOFException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.data[this.position++];
    }

    public int read() throws IOException {
        if (this.position == this.end) {
            return -1;
        }
        return this.data[this.position++] & 0xFF;
    }

    public int available() throws IOException {
        return this.end - this.position;
    }

    public short readShort() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        byte b = this.data[this.position++];
        short i = (short)(b & 0x7F);
        int shift = 7;
        while ((b & 0x80) != 0) {
            if (this.position == this.end) {
                throw new EOFException();
            }
            b = this.data[this.position++];
            i = (short)(i | (b & 0x7F) << shift);
            shift += 7;
        }
        return i;
    }

    public int readInt() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        byte b = this.data[this.position++];
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            if (this.position == this.end) {
                throw new EOFException();
            }
            b = this.data[this.position++];
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public int readFixedInt() throws IOException {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 24;
    }

    public long readLong() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        byte b = this.data[this.position++];
        long i = (long)b & 0x7FL;
        int shift = 7;
        while ((b & 0x80) != 0) {
            if (this.position == this.end) {
                throw new EOFException();
            }
            b = this.data[this.position++];
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public String readUTF() throws IOException, EOFException {
        String s;
        int len = this.readInt();
        try {
            s = new String(this.data, this.position, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            s = new String(this.data, this.position, len);
        }
        this.position += len;
        return s;
    }

    public void copyTo(VariableByteOutputStream os, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            byte more;
            do {
                more = this.data[this.position++];
                os.buf.append(more);
            } while ((more & 0x200) > 0);
        }
    }

    public void copyRaw(VariableByteOutputStream os, int count) throws IOException {
        os.buf.append(this.data, this.position, count);
        this.position += count;
    }

    public void skip(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            while (this.position < this.end && (this.data[this.position++] & 0x80) > 0) {
            }
        }
    }

    public void skipBytes(long count) throws IOException {
        for (long i = 0L; i < count && this.position < this.end; ++i) {
            ++this.position;
        }
    }

    public String toString(int len) {
        byte[] subArray = new byte[len];
        System.arraycopy(this.data, this.position, subArray, 0, len);
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(subArray[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

