/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.storage.lock.Lock;
import org.exist.util.hashtable.Int2ObjectHashMap;

public class LockedDocumentMap
extends Int2ObjectHashMap {
    public LockedDocumentMap() {
        super(29, 1.75);
    }

    public void add(DocumentImpl doc) {
        LockedDocument entry = (LockedDocument)this.get(doc.getDocId());
        if (entry == null) {
            entry = new LockedDocument(doc);
            this.put(doc.getDocId(), entry);
        }
        entry.locksAcquired++;
    }

    public DocumentSet toDocumentSet() {
        DocumentSet docs = new DocumentSet(this.size());
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            LockedDocument d = (LockedDocument)this.values[idx];
            docs.add(d.document);
        }
        return docs;
    }

    public DocumentSet getDocsByCollection(Collection collection, boolean includeSubColls, DocumentSet targetSet) {
        if (targetSet == null) {
            targetSet = new DocumentSet(this.size());
        }
        for (int idx = 0; idx < this.tabSize; ++idx) {
            LockedDocument d;
            if (this.values[idx] == null || this.values[idx] == REMOVED || !(d = (LockedDocument)this.values[idx]).document.getCollection().getURI().startsWith(collection.getURI())) continue;
            targetSet.add(d.document);
        }
        return targetSet;
    }

    public void unlock() {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            LockedDocument d = (LockedDocument)this.values[idx];
            this.unlockDocument(d);
        }
    }

    public LockedDocumentMap unlockSome(DocumentSet keep) {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            LockedDocument d;
            if (this.values[idx] == null || this.values[idx] == REMOVED || keep.containsKey((d = (LockedDocument)this.values[idx]).document.getDocId())) continue;
            this.values[idx] = REMOVED;
            this.unlockDocument(d);
        }
        return this;
    }

    private void unlockDocument(LockedDocument d) {
        Lock dlock = d.document.getUpdateLock();
        dlock.release(1, d.locksAcquired);
    }

    private static class LockedDocument {
        private DocumentImpl document;
        private int locksAcquired = 0;

        public LockedDocument(DocumentImpl document) {
            this.document = document;
        }
    }
}

