/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.recovery;

import java.io.File;
import org.apache.log4j.Logger;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.Journal;
import org.exist.storage.journal.JournalReader;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.journal.Lsn;
import org.exist.storage.txn.Checkpoint;
import org.exist.util.ProgressBar;
import org.exist.util.hashtable.Long2ObjectHashMap;
import org.exist.util.sanity.SanityCheck;

public class RecoveryManager {
    private static final Logger LOG = Logger.getLogger((Class)RecoveryManager.class);
    private Journal logManager;
    private DBBroker broker;
    private boolean restartOnError;

    public RecoveryManager(DBBroker broker, Journal log, boolean restartOnError) {
        this.broker = broker;
        this.logManager = log;
        this.restartOnError = restartOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover() throws LogException {
        boolean recoveryRun = false;
        File[] files = this.logManager.getFiles();
        int lastNum = Journal.findLastFile(files);
        if (-1 < lastNum) {
            File last = this.logManager.getFile(lastNum);
            JournalReader reader = new JournalReader(this.broker, last, lastNum);
            try {
                boolean checkpointFound = false;
                try {
                    Checkpoint checkpoint;
                    Loggable lastLog = reader.lastEntry();
                    if (lastLog != null && lastLog.getLogType() == 2 && (checkpoint = (Checkpoint)lastLog).getStoredLsn() == checkpoint.getLsn()) {
                        checkpointFound = true;
                        LOG.debug((Object)("Database is in clean state. Last checkpoint: " + checkpoint.getDateString()));
                    }
                }
                catch (LogException e) {
                    LOG.info((Object)("Reading last journal log entry failed: " + e.getMessage() + ". Will scan the log..."));
                    checkpointFound = false;
                }
                if (!checkpointFound) {
                    Loggable next;
                    long lastLsn;
                    AbstractLoggable lastCheckpoint;
                    Long2ObjectHashMap txnsStarted;
                    block24: {
                        LOG.info((Object)"Scanning journal...");
                        reader.position(1L);
                        txnsStarted = new Long2ObjectHashMap();
                        lastCheckpoint = null;
                        lastLsn = -1L;
                        try {
                            ProgressBar progress = new ProgressBar("Scanning journal ", last.length());
                            while ((next = reader.nextEntry()) != null) {
                                progress.set(Lsn.getOffset(next.getLsn()));
                                this.broker.getBrokerPool().signalSystemStatus("startup");
                                if (next.getLogType() == 0) {
                                    txnsStarted.put(next.getTransactionId(), next);
                                } else if (next.getLogType() == 3) {
                                    txnsStarted.remove(next.getTransactionId());
                                } else if (next.getLogType() == 2) {
                                    txnsStarted.clear();
                                    lastCheckpoint = (Checkpoint)next;
                                }
                                lastLsn = next.getLsn();
                            }
                        }
                        catch (LogException e) {
                            if (!LOG.isDebugEnabled()) break block24;
                            LOG.debug((Object)"Caught exception while reading log", (Throwable)e);
                            LOG.debug((Object)("Last readable log entry lsn: " + Lsn.dump(lastLsn)));
                        }
                    }
                    if ((lastCheckpoint == null || lastCheckpoint.getLsn() != lastLsn) && txnsStarted.size() > 0) {
                        LOG.info((Object)("Dirty transactions: " + txnsStarted.size()));
                        if (lastCheckpoint == null) {
                            reader.position(1L);
                        } else {
                            reader.position(lastCheckpoint.getLsn());
                            next = reader.nextEntry();
                        }
                        recoveryRun = true;
                        try {
                            this.doRecovery(txnsStarted.size(), last, reader, lastLsn);
                        }
                        catch (LogException e) {
                            if (this.restartOnError) {
                                LOG.error((Object)"Errors during recovery. Database will start up, but corruptions are likely.");
                            }
                            throw e;
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Database is in clean state.");
                    }
                }
                this.cleanDirectory(files);
            }
            finally {
                reader.close();
            }
        }
        this.logManager.setCurrentFileNum(lastNum);
        this.logManager.switchFiles();
        return recoveryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecovery(int txnCount, File last, JournalReader reader, long lastLsn) throws LogException {
        block29: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Running recovery ...");
            }
            this.logManager.setInRecovery(true);
            try {
                Long2ObjectHashMap runningTxns = new Long2ObjectHashMap();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("First pass: redoing " + txnCount + " transactions..."));
                }
                ProgressBar progress = new ProgressBar("Redo ", last.length());
                Loggable next = null;
                int redoCnt = 0;
                try {
                    while ((next = reader.nextEntry()) != null) {
                        SanityCheck.ASSERT(next.getLogType() != 2, "Found a checkpoint during recovery run! This should not ever happen.");
                        this.broker.getBrokerPool().signalSystemStatus("startup");
                        if (next.getLogType() == 0) {
                            runningTxns.put(next.getTransactionId(), next);
                        } else if (next.getLogType() == 1) {
                            runningTxns.remove(next.getTransactionId());
                            ++redoCnt;
                        } else if (next.getLogType() == 3) {
                            runningTxns.remove(next.getTransactionId());
                        }
                        next.redo();
                        progress.set(Lsn.getOffset(next.getLsn()));
                        if (next.getLsn() != lastLsn) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Exception caught while redoing transactions. Aborting recovery.", (Throwable)e);
                    if (next != null) {
                        LOG.warn((Object)("Log entry that caused the exception: " + next.dump()));
                    }
                    throw new LogException("Recovery aborted");
                }
                finally {
                    LOG.info((Object)("Redo processed " + redoCnt + " out of " + txnCount + " transactions."));
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Second pass: undoing dirty transactions. Uncommitted transactions: " + runningTxns.size()));
                }
                if (runningTxns.size() <= 0) break block29;
                try {
                    while ((next = reader.previousEntry()) != null) {
                        if (next.getLogType() == 0) {
                            if (runningTxns.get(next.getTransactionId()) != null) {
                                runningTxns.remove(next.getTransactionId());
                                if (runningTxns.size() == 0) {
                                    break;
                                }
                            }
                        } else if (next.getLogType() != 1 && next.getLogType() == 2) {
                            break;
                        }
                        if (runningTxns.get(next.getTransactionId()) != null) {
                            next.undo();
                        }
                        this.broker.getBrokerPool().signalSystemStatus("startup");
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception caught while undoing dirty transactions. Remaining transactions to be undone: " + runningTxns.size()), (Throwable)e);
                    if (next != null) {
                        LOG.warn((Object)("Log entry that caused the exception: " + next.dump()));
                    }
                    throw new LogException("Recovery aborted");
                }
            }
            finally {
                this.broker.getBrokerPool().signalSystemStatus("startup");
                this.broker.sync(1);
                this.logManager.setInRecovery(false);
            }
        }
    }

    private void cleanDirectory(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }
}

