/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exist.dom.NodeProxy;
import org.exist.util.HeapSort;
import org.exist.util.InsertionSort;
import org.exist.util.SwapVals;

public final class FastQSort {
    private static final int M = 10;
    private static final double LOG2 = Math.log(2.0);

    private static final void IntroSort(Comparable[] a, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r);
                return;
            }
            int i = (l + r) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (a[l].compareTo(a[r]) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (a[i].compareTo(a[r]) > 0) {
                SwapVals.swap(a, i, r);
            }
            Comparable partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.compareTo(a[i]) > 0) {
                    ++i;
                }
                while (j > l && partionElement.compareTo(a[j]) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSort(a, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
        InsertionSort.sort(a, l, r);
    }

    private static final void IntroSort(Comparable[] a, int l, int r, int[] b, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r, b);
                return;
            }
            int i = (l + r) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                SwapVals.swap(a, l, i);
                if (b != null) {
                    SwapVals.swap(b, l, i);
                }
            }
            if (a[l].compareTo(a[r]) > 0) {
                SwapVals.swap(a, l, r);
                if (b != null) {
                    SwapVals.swap(b, l, r);
                }
            }
            if (a[i].compareTo(a[r]) > 0) {
                SwapVals.swap(a, i, r);
                if (b != null) {
                    SwapVals.swap(b, i, r);
                }
            }
            Comparable partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.compareTo(a[i]) > 0) {
                    ++i;
                }
                while (j > l && partionElement.compareTo(a[j]) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                if (b != null) {
                    SwapVals.swap(b, i, j);
                }
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSort(a, l, j, b, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
        InsertionSort.sort(a, l, r, b);
    }

    private static final void IntroSort(Object[] a, Comparator comp, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, comp, l, r);
                return;
            }
            int i = (l + r) / 2;
            if (comp.compare(a[l], a[i]) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (comp.compare(a[l], a[r]) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (comp.compare(a[i], a[r]) > 0) {
                SwapVals.swap(a, i, r);
            }
            Object partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && comp.compare(partionElement, a[i]) > 0) {
                    ++i;
                }
                while (j > l && comp.compare(partionElement, a[j]) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSort(a, comp, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
        InsertionSort.sort(a, comp, l, r);
    }

    private static final void IntroSort(NodeProxy[] a, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r);
                return;
            }
            int i = (l + r) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (a[l].compareTo(a[r]) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (a[i].compareTo(a[r]) > 0) {
                SwapVals.swap(a, i, r);
            }
            NodeProxy partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.compareTo(a[i]) > 0) {
                    ++i;
                }
                while (j > l && partionElement.compareTo(a[j]) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSort(a, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
        InsertionSort.sort(a, l, r);
    }

    private static final void IntroSort(List a, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r);
                return;
            }
            int i = (l + r) / 2;
            if (((Comparable)a.get(l)).compareTo(a.get(i)) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (((Comparable)a.get(l)).compareTo(a.get(r)) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (((Comparable)a.get(i)).compareTo(a.get(r)) > 0) {
                SwapVals.swap(a, i, r);
            }
            Object partionElement = a.get(i);
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && ((Comparable)partionElement).compareTo(a.get(i)) > 0) {
                    ++i;
                }
                while (j > l && ((Comparable)partionElement).compareTo(a.get(j)) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSort(a, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
        InsertionSort.sort(a, l, r);
    }

    private static final void IntroSort(long[] a, int l, int r, Object[] b, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r, b);
                return;
            }
            int i = (l + r) / 2;
            if (a[l] > a[i]) {
                SwapVals.swap(a, l, i);
                if (b != null) {
                    SwapVals.swap(b, l, i);
                }
            }
            if (a[l] > a[r]) {
                SwapVals.swap(a, l, r);
                if (b != null) {
                    SwapVals.swap(b, l, r);
                }
            }
            if (a[i] > a[r]) {
                SwapVals.swap(a, i, r);
                if (b != null) {
                    SwapVals.swap(b, i, r);
                }
            }
            long partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement > a[i]) {
                    ++i;
                }
                while (j > l && partionElement < a[j]) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                if (b != null) {
                    SwapVals.swap(b, i, j);
                }
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSort(a, l, j, b, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
        InsertionSort.sort(a, l, r, b);
    }

    private static final void IntroSortByNodeId(NodeProxy[] a, int l, int r, int maxdepth) {
        while (r - l > 10) {
            if (maxdepth <= 0) {
                HeapSort.sort(a, l, r);
                return;
            }
            int i = (l + r) / 2;
            if (a[l].getNodeId().compareTo(a[i].getNodeId()) > 0) {
                SwapVals.swap(a, l, i);
            }
            if (a[l].getNodeId().compareTo(a[r].getNodeId()) > 0) {
                SwapVals.swap(a, l, r);
            }
            if (a[i].getNodeId().compareTo(a[r].getNodeId()) > 0) {
                SwapVals.swap(a, i, r);
            }
            NodeProxy partionElement = a[i];
            i = l + 1;
            int j = r - 1;
            while (i <= j) {
                while (i < r && partionElement.getNodeId().compareTo(a[i].getNodeId()) > 0) {
                    ++i;
                }
                while (j > l && partionElement.getNodeId().compareTo(a[j].getNodeId()) < 0) {
                    --j;
                }
                if (i > j) continue;
                SwapVals.swap(a, i, j);
                ++i;
                --j;
            }
            if (l < j) {
                FastQSort.IntroSortByNodeId(a, l, j, maxdepth);
            }
            if (i >= r) break;
            l = i;
        }
        InsertionSort.sort(a, l, r);
    }

    public static void sort(Comparable[] a, int lo, int hi) {
        if (lo == hi) {
            return;
        }
        FastQSort.IntroSort(a, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
    }

    public static void sort(Comparable[] a, int lo, int hi, int[] b) {
        if (lo == hi) {
            return;
        }
        FastQSort.IntroSort(a, lo, hi, b, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
    }

    public static void sort(Object[] a, Comparator c, int lo, int hi) {
        if (lo == hi) {
            return;
        }
        FastQSort.IntroSort(a, c, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
    }

    public static void sort(List a, int lo, int hi) {
        if (lo == hi) {
            return;
        }
        FastQSort.IntroSort(a, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
    }

    public static void sort(NodeProxy[] a, int lo, int hi) {
        if (lo == hi) {
            return;
        }
        FastQSort.IntroSort(a, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
    }

    public static void sortByNodeId(NodeProxy[] a, int lo, int hi) {
        if (lo == hi) {
            return;
        }
        FastQSort.IntroSortByNodeId(a, lo, hi, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
    }

    public static void sort(long[] a, int lo, int hi, Object[] b) {
        if (lo == hi) {
            return;
        }
        FastQSort.IntroSort(a, lo, hi, b, 2 * (int)Math.floor(Math.log(hi - lo + 1) / LOG2));
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        if (args.length == 0) {
            String[] a = new String[]{"Rudi", "Herbert", "Anton", "Berta", "Olga", "Willi", "Heinz"};
            for (int i = 0; i < a.length; ++i) {
                l.add(a[i]);
            }
        } else {
            System.err.println("Ordering file " + args[0] + "\n");
            try {
                String rr;
                BufferedReader is = new BufferedReader(new FileReader(args[0]));
                while ((rr = is.readLine()) != null) {
                    l.add(rr);
                }
                is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long a = System.currentTimeMillis();
        FastQSort.sort(l, 0, l.size() - 1);
        long b = System.currentTimeMillis();
        System.err.println("Ellapsed time: " + (b - a) + " size: " + l.size());
        for (int i = 0; i < l.size(); ++i) {
            System.out.println(l.get(i));
        }
    }
}

