/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;

public class ValueOccurrences {
    private AtomicValue value;
    private int occurrences = 0;
    private DocumentSet docs = new DocumentSet();

    public ValueOccurrences(AtomicValue value) {
        this.value = value;
    }

    public AtomicValue getValue() {
        return this.value;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public void addOccurrences(int count) {
        this.occurrences += count;
    }

    public void addDocument(DocumentImpl doc) {
        if (!this.docs.contains(doc.getDocId())) {
            this.docs.add(doc);
        }
    }

    public void add(ValueOccurrences other) {
        this.addOccurrences(other.occurrences);
        this.docs.addAll(other.docs);
    }

    public int getDocuments() {
        return this.docs.getLength();
    }

    public int compareTo(Object o) {
        try {
            return this.value.compareTo(null, ((ValueOccurrences)o).value);
        }
        catch (XPathException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("Value: '" + this.value.getStringValue() + "'");
        }
        catch (XPathException e) {
            buf.append("Value: '" + e.getMessage() + "'");
        }
        buf.append(" occurences: '" + this.occurrences + "'");
        buf.append(" documents: '" + this.docs.getLength() + "'");
        return buf.toString();
    }
}

