/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import org.exist.memtree.ReferenceNode;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.DOMStreamer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ExtendedDOMStreamer
extends DOMStreamer {
    private Serializer xmlSerializer;

    public ExtendedDOMStreamer() {
    }

    public ExtendedDOMStreamer(Serializer xmlSerializer) {
        this.xmlSerializer = xmlSerializer;
    }

    public ExtendedDOMStreamer(Serializer xmlSerializer, ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        super(contentHandler, lexicalHandler);
        this.xmlSerializer = xmlSerializer;
    }

    public void setSerializer(Serializer serializer) {
        this.xmlSerializer = serializer;
    }

    protected void startNode(Node node) throws SAXException {
        if (node.getNodeType() == 100) {
            if (this.xmlSerializer == null) {
                throw new SAXException("Cannot serialize node reference. Serializer is undefined.");
            }
            this.xmlSerializer.toReceiver(((ReferenceNode)node).getReference(), true);
        } else {
            super.startNode(node);
        }
    }

    public void reset() {
        super.reset();
        this.xmlSerializer = null;
    }
}

