/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.serializer.XMLWriter;

public class IndentingXMLWriter
extends XMLWriter {
    private boolean indent = false;
    private int indentAmount = 4;
    private String indentChars = "                                                                                           ";
    private int level = 0;
    private boolean afterTag = false;
    private boolean sameline = false;

    public IndentingXMLWriter() {
    }

    public IndentingXMLWriter(Writer writer) {
        super(writer);
    }

    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.level = 0;
        this.afterTag = false;
        this.sameline = false;
    }

    public void startElement(String qname) throws TransformerException {
        if (this.afterTag) {
            this.indent();
        }
        super.startElement(qname);
        ++this.level;
        this.afterTag = true;
        this.sameline = true;
    }

    public void startElement(QName qname) throws TransformerException {
        if (this.afterTag) {
            this.indent();
        }
        super.startElement(qname);
        ++this.level;
        this.afterTag = true;
        this.sameline = true;
    }

    public void endElement(String qname) throws TransformerException {
        --this.level;
        if (this.afterTag && !this.sameline) {
            this.indent();
        }
        super.endElement(qname);
        this.sameline = false;
        this.afterTag = true;
    }

    public void endElement(QName qname) throws TransformerException {
        --this.level;
        if (this.afterTag && !this.sameline) {
            this.indent();
        }
        super.endElement(qname);
        this.sameline = false;
        this.afterTag = true;
    }

    public void characters(CharSequence chars) throws TransformerException {
        int start = 0;
        int length = chars.length();
        if (length == 0) {
            return;
        }
        if (start > 0 || length < chars.length()) {
            chars = chars.subSequence(start, length);
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != '\n') continue;
            this.sameline = false;
        }
        this.afterTag = false;
        super.characters(chars);
    }

    public void comment(CharSequence data) throws TransformerException {
        super.comment(data);
        this.afterTag = true;
    }

    public void processingInstruction(String target, String data) throws TransformerException {
        super.processingInstruction(target, data);
        this.afterTag = true;
    }

    public void documentType(String name, String publicId, String systemId) throws TransformerException {
        super.documentType(name, publicId, systemId);
        super.characters("\n");
        this.sameline = false;
    }

    public void setOutputProperties(Properties properties) {
        super.setOutputProperties(properties);
        String option = this.outputProperties.getProperty("indent-spaces", "4");
        try {
            this.indentAmount = Integer.parseInt(option);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.indent = this.outputProperties.getProperty("indent", "no").equals("yes");
    }

    protected void indent() throws TransformerException {
        if (!this.indent) {
            return;
        }
        int spaces = this.indentAmount * this.level;
        while (spaces >= this.indentChars.length()) {
            this.indentChars = this.indentChars + this.indentChars;
        }
        super.characters("\n");
        super.characters(this.indentChars.subSequence(0, spaces));
        this.sameline = false;
    }

    protected static final boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }
}

