/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.util.serializer.IndentingXMLWriter;

public class XHTMLWriter
extends IndentingXMLWriter {
    private static ObjectHashSet emptyTags = new ObjectHashSet(31);
    private String currentTag;

    private static boolean isEmptyTag(String tag) {
        return emptyTags.contains(tag);
    }

    public XHTMLWriter() {
    }

    public XHTMLWriter(Writer writer) {
        super(writer);
    }

    public void startElement(QName qname) throws TransformerException {
        super.startElement(qname);
        this.currentTag = qname.toString();
    }

    public void startElement(String qname) throws TransformerException {
        super.startElement(qname);
        this.currentTag = qname;
    }

    protected void closeStartTag(boolean isEmpty) throws TransformerException {
        try {
            if (this.tagIsOpen) {
                if (isEmpty) {
                    if (XHTMLWriter.isEmptyTag(this.currentTag)) {
                        this.writer.write(" />");
                    } else {
                        this.writer.write(62);
                        this.writer.write("</");
                        this.writer.write(this.currentTag);
                        this.writer.write(62);
                    }
                } else {
                    this.writer.write(62);
                }
                this.tagIsOpen = false;
            }
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    static {
        emptyTags.add("area");
        emptyTags.add("base");
        emptyTags.add("br");
        emptyTags.add("col");
        emptyTags.add("hr");
        emptyTags.add("img");
        emptyTags.add("input");
        emptyTags.add("link");
        emptyTags.add("meta");
        emptyTags.add("basefont");
        emptyTags.add("frame");
        emptyTags.add("isindex");
        emptyTags.add("param");
    }
}

