/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.service;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.exist.validation.Validator;
import org.exist.validation.service.ValidationService;
import org.exist.xmldb.RemoteCollection;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteValidationService
implements ValidationService {
    private static Logger logger = Logger.getLogger((Class)RemoteValidationService.class);
    private XmlRpcClient client = null;
    private RemoteCollection remoteCollection = null;
    private Validator validator = null;

    public RemoteValidationService(RemoteCollection parent, XmlRpcClient client) {
        logger.info((Object)"Starting RemoteValidationService");
        this.client = client;
        this.remoteCollection = parent;
    }

    public boolean validateResource(String id) throws XMLDBException {
        return this.validateResource(id, null);
    }

    public boolean validateResource(String documentPath, String grammarPath) throws XMLDBException {
        if (documentPath.startsWith("/")) {
            documentPath = "xmldb:exist://" + documentPath;
        }
        if (grammarPath != null && grammarPath.startsWith("/")) {
            grammarPath = "xmldb:exist://" + grammarPath;
        }
        logger.info((Object)("Validating resource '" + documentPath + "'"));
        boolean documentIsValid = false;
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(documentPath);
        if (grammarPath != null) {
            params.add(grammarPath);
        }
        try {
            Boolean result = (Boolean)this.client.execute("isValid", params);
            documentIsValid = result;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        return documentIsValid;
    }

    public void setCollection(Collection collection) throws XMLDBException {
    }

    public String getName() throws XMLDBException {
        return "ValidationService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setProperty(String str, String str1) throws XMLDBException {
    }

    public String getProperty(String str) throws XMLDBException {
        return null;
    }
}

