/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exist.webstart.JnlpHelper;
import org.exist.webstart.JnlpJarFiles;
import org.exist.webstart.JnlpWriter;

public class JnlpServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger((Class)JnlpServlet.class);
    private JnlpJarFiles jf = null;
    private JnlpHelper jh = null;

    public void init() {
        logger.info((Object)"Initializing JNLP servlet");
        String realPath = this.getServletContext().getRealPath("/");
        if (realPath == null) {
            logger.error((Object)"getServletContext().getRealPath() did not return a value. Webstart is not available.");
        }
        File contextRoot = new File(realPath);
        this.jh = new JnlpHelper(contextRoot);
        this.jf = new JnlpJarFiles(this.jh);
    }

    private String stripFilename(String URI2) {
        int lastPos = URI2.lastIndexOf("/");
        return URI2.substring(lastPos + 1);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block7: {
            try {
                JnlpWriter jw = new JnlpWriter();
                String URI2 = request.getRequestURI();
                logger.debug((Object)("Requested URI=" + URI2));
                if (URI2.endsWith(".jnlp")) {
                    jw.writeJnlpXML(this.jf, request, response);
                    break block7;
                }
                if (URI2.endsWith(".jar")) {
                    String filename = this.stripFilename(request.getPathInfo());
                    jw.sendJar(this.jf, filename, request, response);
                    break block7;
                }
                if (URI2.endsWith(".gif") || URI2.endsWith(".jpg")) {
                    String filename = this.stripFilename(request.getPathInfo());
                    jw.sendImage(this.jh, this.jf, filename, response);
                    break block7;
                }
                logger.error((Object)"Invalid filename extension.");
                response.sendError(403, "Invalid filename extension.");
                return;
            }
            catch (EOFException ex) {
                logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (SocketException ex) {
                logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable e) {
                logger.error((Object)e);
                throw new ServletException("An error occurred: " + e.getMessage(), e);
            }
        }
    }
}

