/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URI;
import java.net.URISyntaxException;
import org.exist.xmldb.XmldbURI;

public class FullXmldbURI
extends XmldbURI {
    private URI wrappedURI;
    private String context;
    private String apiName;

    protected FullXmldbURI(URI xmldbURI) throws URISyntaxException {
        super(xmldbURI);
    }

    protected void parseURI(URI xmldbURI, boolean hadXmldbPrefix) throws URISyntaxException {
        this.wrappedURI = xmldbURI;
        if (hadXmldbPrefix) {
            if (this.wrappedURI.getScheme() == null) {
                throw new URISyntaxException("xmldb:" + this.wrappedURI.toString(), "xmldb URI scheme has no instance name");
            }
            String userInfo = this.wrappedURI.getUserInfo();
            if (this.wrappedURI.getHost() == null && this.wrappedURI.getAuthority() != null && (userInfo = this.wrappedURI.getAuthority()).endsWith("@")) {
                userInfo = userInfo.substring(0, userInfo.length() - 1);
            }
            if (userInfo != null) {
                StringBuffer recomputed = new StringBuffer();
                recomputed.append(this.wrappedURI.getScheme());
                recomputed.append("://");
                recomputed.append(this.wrappedURI.getHost());
                if (this.wrappedURI.getPort() != -1) {
                    recomputed.append(":").append(this.wrappedURI.getPort());
                }
                recomputed.append(this.wrappedURI.getRawPath());
                this.wrappedURI = new URI(recomputed.toString());
            }
        }
        super.parseURI(xmldbURI, hadXmldbPrefix);
    }

    protected void splitPath(String path) throws URISyntaxException {
        int index = -1;
        int lastIndex = -1;
        this.context = null;
        String pathForSuper = null;
        if (path != null) {
            String host = this.getHost();
            if (host == null || "embedded-eXist-server".equals(host)) {
                if (this.getPort() != -1) {
                    throw new URISyntaxException("xmldb:" + this.wrappedURI.toString(), "Local xmldb URI should not provide a port");
                }
                this.apiName = "local";
                this.context = null;
                pathForSuper = path;
            } else {
                index = path.lastIndexOf("/xmlrpc");
                if (index > lastIndex) {
                    this.apiName = "xmlrpc";
                    pathForSuper = path.substring(index + "/xmlrpc".length());
                    this.context = path.substring(0, index) + "/xmlrpc";
                    lastIndex = index;
                }
                if ((index = path.lastIndexOf("/webdav")) > lastIndex) {
                    this.apiName = "webdav";
                    pathForSuper = path.substring(index + "/webdav".length());
                    this.context = path.substring(0, index) + "/webdav";
                    lastIndex = index;
                }
                if (this.apiName == null) {
                    this.apiName = "rest-style";
                    pathForSuper = path;
                    this.context = null;
                }
            }
        }
        super.splitPath(pathForSuper);
    }

    protected void recomputeURI() throws URISyntaxException {
        URI oldWrappedURI = this.wrappedURI;
        StringBuffer buf = new StringBuffer();
        if (this.getInstanceName() != null) {
            buf.append(this.getInstanceName()).append("://");
        }
        if (this.getHost() != null) {
            buf.append(this.getHost());
        }
        if (this.getPort() != -1) {
            buf.append(":" + this.getPort());
        }
        if (this.context != null) {
            buf.append(this.context);
        }
        if (this.getRawCollectionPath() != null) {
            buf.append(this.getRawCollectionPath());
        }
        try {
            this.wrappedURI = new URI(buf.toString());
        }
        catch (URISyntaxException e) {
            this.wrappedURI = oldWrappedURI;
            throw e;
        }
    }

    private void setContext(String context) {
        String oldContext = this.context;
        try {
            if (context != null && context.endsWith("/") && this.getHost() != null) {
                context = context.substring(0, context.length() - 1);
            }
            this.context = "".equals(context) ? null : context;
            this.recomputeURI();
        }
        catch (URISyntaxException e) {
            this.context = oldContext;
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    public URI getURI() {
        return this.wrappedURI;
    }

    public URI getXmldbURI() {
        return URI.create("xmldb:" + this.wrappedURI.toString());
    }

    public String getInstanceName() {
        return this.wrappedURI.getScheme();
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isAbsolute() {
        return this.wrappedURI.isAbsolute();
    }

    public boolean isContextAbsolute() {
        String context = this.getContext();
        if (context == null) {
            return true;
        }
        return context.startsWith("/");
    }

    public XmldbURI normalizeContext() {
        String context = this.getContext();
        if (context == null) {
            return this;
        }
        URI uri = URI.create(context);
        try {
            FullXmldbURI xmldbURI = new FullXmldbURI(this.getXmldbURI());
            xmldbURI.setContext(uri.normalize().getRawPath());
            return xmldbURI;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getMessage());
        }
    }

    public URI relativizeContext(URI uri) {
        URI contextURI;
        if (uri == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String context = this.getContext();
        if (context == null) {
            throw new NullPointerException("The current context is null");
        }
        if (!context.endsWith("/")) {
            LOG.info((Object)("Added a final '/' to '" + context + "'"));
            contextURI = URI.create(context + "/");
        } else {
            contextURI = URI.create(context);
        }
        return contextURI.relativize(uri);
    }

    public URI resolveContext(String str) throws NullPointerException, IllegalArgumentException {
        URI contextURI;
        if (str == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String context = this.getContext();
        if (context == null) {
            throw new NullPointerException("The current context is null");
        }
        if (!context.endsWith("/")) {
            LOG.info((Object)("Added a final '/' to '" + context + "'"));
            contextURI = URI.create(context + "/");
        } else {
            contextURI = URI.create(context);
        }
        return contextURI.resolve(str);
    }

    public URI resolveContext(URI uri) throws NullPointerException {
        URI contextURI;
        if (uri == null) {
            throw new NullPointerException("The provided URI is null");
        }
        String context = this.getContext();
        if (context == null) {
            throw new NullPointerException("The current context is null");
        }
        if (!context.endsWith("/")) {
            LOG.info((Object)("Added a final '/' to '" + context + "'"));
            contextURI = URI.create(context + "/");
        } else {
            contextURI = URI.create(context);
        }
        return contextURI.resolve(uri);
    }

    public String toString() {
        return "xmldb:" + this.wrappedURI.toString();
    }

    public String getAuthority() {
        return this.wrappedURI.getAuthority();
    }

    public String getFragment() {
        return this.wrappedURI.getFragment();
    }

    public int getPort() {
        return this.wrappedURI.getPort();
    }

    public String getQuery() {
        return this.wrappedURI.getQuery();
    }

    public String getRawAuthority() {
        return this.wrappedURI.getRawAuthority();
    }

    public String getHost() {
        return this.wrappedURI.getHost();
    }

    public String getUserInfo() {
        return this.wrappedURI.getUserInfo();
    }

    public String getRawFragment() {
        return this.wrappedURI.getRawFragment();
    }

    public String getRawQuery() {
        return this.wrappedURI.getRawQuery();
    }

    public String getRawUserInfo() {
        return this.wrappedURI.getRawUserInfo();
    }
}

