/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URISyntaxException;
import org.exist.EXistException;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.dom.DocumentSet;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.Occurrences;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.value.Sequence;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class LocalIndexQueryService
implements IndexQueryService {
    private LocalCollection parent = null;
    private BrokerPool pool = null;
    private User user;

    public LocalIndexQueryService(User user, BrokerPool pool, LocalCollection parent) {
        this.user = user;
        this.pool = pool;
        this.parent = parent;
    }

    public void reindexCollection() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            broker.reindexCollection(this.parent.getCollection().getURI());
            broker.sync(1);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void reindexCollection(String collectionPath) throws XMLDBException {
        try {
            this.reindexCollection(XmldbURI.xmldbUriFor(collectionPath));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void reindexCollection(XmldbURI collectionPath) throws XMLDBException {
        if (this.parent != null) {
            collectionPath = this.parent.getPathURI().resolveCollectionPath(collectionPath);
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            broker.reindexCollection(collectionPath);
            broker.sync(1);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void configureCollection(String configData) throws XMLDBException {
        DBBroker broker = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.pool.get(this.user);
            CollectionConfigurationManager mgr = this.pool.getConfigurationManager();
            mgr.addConfiguration(txn, broker, this.parent.getCollection(), configData);
            transact.commit(txn);
            System.out.println("Configured '" + this.parent.getCollection().getURI() + "'");
        }
        catch (CollectionConfigurationException e) {
            transact.abort(txn);
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Occurrences[] getIndexedElements(boolean inclusive) throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            Occurrences[] occurrencesArray = broker.getElementIndex().scanIndexedElements(this.parent.getCollection(), inclusive);
            return occurrencesArray;
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "database access error", (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, "permission denied", (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public String getName() throws XMLDBException {
        return "IndexQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(Collection col) throws XMLDBException {
        if (!(col instanceof LocalCollection)) {
            throw new XMLDBException(201, "incompatible collection type: " + col.getClass().getName());
        }
        this.parent = (LocalCollection)col;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }

    public Occurrences[] scanIndexTerms(String start, String end, boolean inclusive) throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentSet docs = new DocumentSet();
            this.parent.getCollection().allDocs(broker, docs, inclusive, true);
            Occurrences[] occurrencesArray = broker.getTextEngine().scanIndexTerms(docs, docs.toNodeSet(), start, end);
            return occurrencesArray;
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, "permission denied", (Throwable)e);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "database access error", (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Occurrences[] scanIndexTerms(String xpath, String start, String end) throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            XQuery xquery = broker.getXQueryService();
            Sequence nodes = xquery.execute(xpath, null, this.parent.getAccessContext());
            Occurrences[] occurrencesArray = broker.getTextEngine().scanIndexTerms(nodes.getDocumentSet(), nodes.toNodeSet(), start, end);
            return occurrencesArray;
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "database access error", (Throwable)e);
        }
        catch (XPathException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }
}

