/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public class QueryResult {
    protected long queryTime = 0L;
    protected Sequence result;
    protected Option serialization = null;
    protected long timestamp = 0L;
    protected XPathException exception = null;

    public QueryResult(XQueryContext context, Sequence result) {
        this(context, result, 0L);
    }

    public QueryResult(XQueryContext context, Sequence result, long queryTime) {
        this.serialization = context.getOption(Option.SERIALIZE_QNAME);
        this.result = result;
        this.queryTime = queryTime;
        this.timestamp = System.currentTimeMillis();
    }

    public QueryResult(XPathException e) {
        this.exception = e;
    }

    public boolean hasErrors() {
        return this.exception != null;
    }

    public XPathException getException() {
        return this.exception;
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public Sequence getResult() {
        return this.result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

