/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Map;
import java.util.TreeMap;
import org.exist.dom.NodeSet;
import org.exist.storage.DBBroker;
import org.exist.xquery.Atomize;
import org.exist.xquery.BinaryOp;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class OpNumeric
extends BinaryOp {
    protected final int operator;
    protected int returnType = 20;
    protected NodeSet temp = null;
    protected DBBroker broker;
    private static final int[] OP_TABLE = new int[]{8, 30, 30, 30, 8, 51, 54, 51, 8, 54, 51, 51, 8, 51, 55, 51, 8, 55, 51, 51, 8, 52, 55, 52, 8, 55, 52, 52, 8, 50, 54, 50, 8, 54, 50, 50, 8, 50, 55, 50, 8, 55, 50, 50, 8, 54, 54, 54, 8, 55, 55, 55, 9, 30, 30, 30, 9, 51, 51, 55, 9, 51, 54, 51, 9, 51, 55, 51, 9, 52, 52, 55, 9, 52, 55, 52, 9, 50, 50, 55, 9, 50, 54, 50, 9, 50, 55, 50, 9, 54, 54, 54, 9, 55, 55, 55, 10, 30, 30, 30, 10, 54, 30, 54, 10, 30, 54, 54, 10, 55, 30, 55, 10, 30, 55, 55, 13, 30, 30, 31, 11, 30, 30, 30, 11, 54, 30, 54, 11, 55, 30, 55, 11, 54, 54, 32, 11, 55, 55, 32, 12, 30, 30, 30};
    private static final Map OP_TYPES = new TreeMap();

    public OpNumeric(XQueryContext context, int operator) {
        super(context);
        this.operator = operator;
    }

    public OpNumeric(XQueryContext context, Expression left, Expression right, int operator) {
        super(context);
        this.operator = operator;
        left = this.atomizeIfNecessary(left);
        right = this.atomizeIfNecessary(right);
        int ltype = left.returnsType();
        int rtype = right.returnsType();
        if (Type.subTypeOf(ltype, 30) && Type.subTypeOf(rtype, 30)) {
            if (ltype > rtype) {
                right = new UntypedValueCheck(context, ltype, right);
            } else if (rtype > ltype) {
                left = new UntypedValueCheck(context, rtype, left);
            }
            this.returnType = operator == 11 && ltype == 31 && rtype == 31 ? 32 : (operator == 13 ? 31 : Math.max(ltype, rtype));
        } else {
            OpEntry entry;
            if (Type.subTypeOf(ltype, 30)) {
                ltype = 30;
            }
            if (Type.subTypeOf(rtype, 30)) {
                rtype = 30;
            }
            if ((entry = (OpEntry)OP_TYPES.get(new OpEntry(operator, ltype, rtype))) != null) {
                this.returnType = entry.typeResult;
            }
        }
        this.add(left);
        this.add(right);
    }

    private Expression atomizeIfNecessary(Expression x) {
        return Type.subTypeOf(x.returnsType(), 20) ? x : new Atomize(this.context, x);
    }

    public int returnsType() {
        return this.returnType;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence lseq = this.getLeft().eval(contextSequence);
        Sequence rseq = this.getRight().eval(contextSequence);
        if (lseq.hasMany()) {
            throw new XPathException(this.getASTNode(), "XPTY0004: too many operands at the left of " + Constants.OPS[this.operator]);
        }
        if (rseq.hasMany()) {
            throw new XPathException(this.getASTNode(), "XPTY0004: too many operands at the right of " + Constants.OPS[this.operator]);
        }
        if (rseq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else if (lseq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Item lvalue = lseq.itemAt(0);
            Item rvalue = rseq.itemAt(0);
            try {
                if (lvalue.getType() == 21 || lvalue.getType() == 20) {
                    lvalue = lvalue.convertTo(30);
                }
                if (rvalue.getType() == 21 || rvalue.getType() == 20) {
                    rvalue = rvalue.convertTo(30);
                }
                if (!(lvalue instanceof ComputableValue)) {
                    throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")' can not be an operand for " + Constants.OPS[this.operator]);
                }
                if (!(rvalue instanceof ComputableValue)) {
                    throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(rvalue.getType()) + "(" + rvalue + ")' can not be an operand for " + Constants.OPS[this.operator]);
                }
                if (this.operator == 13) {
                    if (!Type.subTypeOf(lvalue.getType(), 30)) {
                        throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")' can not be an operand for " + Constants.OPS[this.operator]);
                    }
                    if (!Type.subTypeOf(rvalue.getType(), 30)) {
                        throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(rvalue.getType()) + "(" + rvalue + ")' can not be an operand for " + Constants.OPS[this.operator]);
                    }
                    if (((NumericValue)rvalue).isZero()) {
                        throw new XPathException(this.getASTNode(), "FOAR0001: division by zero");
                    }
                    if (((NumericValue)lvalue).isNaN()) {
                        throw new XPathException(this.getASTNode(), "FOAR0002: division of " + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")'");
                    }
                    if (((NumericValue)rvalue).isNaN()) {
                        throw new XPathException(this.getASTNode(), "FOAR0002: division of " + Type.getTypeName(rvalue.getType()) + "(" + rvalue + ")'");
                    }
                    if (((NumericValue)lvalue).isInfinite()) {
                        throw new XPathException(this.getASTNode(), "FOAR0002: division of " + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")'");
                    }
                    result = ((NumericValue)lvalue).idiv((NumericValue)rvalue);
                } else {
                    result = this.applyOperator((ComputableValue)lvalue, (ComputableValue)rvalue);
                }
            }
            catch (XPathException e) {
                e.setASTNode(this.getASTNode());
                throw e;
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        if (this.returnType == 20) {
            this.returnType = result.getItemType();
        }
        return result;
    }

    public ComputableValue applyOperator(ComputableValue left, ComputableValue right) throws XPathException {
        switch (this.operator) {
            case 9: {
                return left.minus(right);
            }
            case 8: {
                return left.plus(right);
            }
            case 10: {
                return left.mult(right);
            }
            case 11: {
                return left.div(right);
            }
            case 12: {
                if (!Type.subTypeOf(left.getType(), 30)) {
                    throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(left.getType()) + "(" + left + ")' is not numeric");
                }
                if (!Type.subTypeOf(right.getType(), 30)) {
                    throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(right.getType()) + "(" + right + ")' is not numeric");
                }
                return ((NumericValue)left).mod((NumericValue)right);
            }
        }
        throw new RuntimeException("unknown numeric operator " + this.operator);
    }

    public void dump(ExpressionDumper dumper) {
        this.getLeft().dump(dumper);
        dumper.display(' ').display(Constants.OPS[this.operator]).display(' ');
        this.getRight().dump(dumper);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getLeft().toString());
        result.append(' ').append(Constants.OPS[this.operator]).append(' ');
        result.append(this.getRight());
        return result.toString();
    }

    static {
        for (int i = 0; i < OP_TABLE.length; i += 4) {
            OpEntry entry = new OpEntry(OP_TABLE[i], OP_TABLE[i + 1], OP_TABLE[i + 2], OP_TABLE[i + 3]);
            OP_TYPES.put(entry, entry);
        }
    }

    private static class OpEntry
    implements Comparable {
        public final int op;
        public final int typeA;
        public final int typeB;
        public final int typeResult;

        public OpEntry(int op, int typeA, int typeB) {
            this(op, typeA, typeB, 20);
        }

        public OpEntry(int op, int typeA, int typeB, int typeResult) {
            this.op = op;
            this.typeA = typeA;
            this.typeB = typeB;
            this.typeResult = typeResult;
        }

        public int compareTo(Object o) {
            OpEntry that = (OpEntry)o;
            if (this.op != that.op) {
                return this.op - that.op;
            }
            if (this.typeA != that.typeA) {
                return this.typeA - that.typeA;
            }
            if (this.typeB != that.typeB) {
                return this.typeB - that.typeB;
            }
            return 0;
        }

        public boolean equals(Object o) {
            try {
                OpEntry that = (OpEntry)o;
                return this.op == that.op && this.typeA == that.typeA && this.typeB == that.typeB;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

