/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Constants;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class Step
extends AbstractExpression {
    protected static final Logger LOG = Logger.getLogger((Class)Step.class);
    protected int axis = -1;
    protected boolean abbreviatedStep = false;
    protected ArrayList predicates = new ArrayList();
    protected NodeTest test;
    protected boolean inPredicate = false;
    protected int staticReturnType = 11;

    public Step(XQueryContext context, int axis) {
        super(context);
        this.axis = axis;
    }

    public Step(XQueryContext context, int axis, NodeTest test) {
        this(context, axis);
        this.test = test;
    }

    public void addPredicate(Expression expr) {
        this.predicates.add(expr);
    }

    public void insertPredicate(Expression previous, Expression predicate) {
        int idx = this.predicates.indexOf(previous);
        if (idx < 0) {
            LOG.warn((Object)("Old predicate not found: " + ExpressionDumper.dump(previous) + "; in: " + ExpressionDumper.dump(this)));
            return;
        }
        this.predicates.add(idx + 1, predicate);
    }

    public boolean hasPredicates() {
        return this.predicates.size() > 0;
    }

    public List getPredicates() {
        return this.predicates;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (this.test != null && this.test.getName() != null && this.test.getName().getPrefix() != null && !this.test.getName().getPrefix().equals("") && this.context.inScopePrefixes != null && this.context.getURIForPrefix(this.test.getName().getPrefix()) == null) {
            throw new XPathException(this.getASTNode(), "XPST0081 : undeclared prefix '" + this.test.getName().getPrefix() + "'");
        }
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.contextId = contextInfo.getContextId();
        if (this.predicates.size() > 0) {
            AnalyzeContextInfo newContext = new AnalyzeContextInfo(contextInfo);
            newContext.setStaticType(this.axis == 12 ? contextInfo.getStaticType() : -1);
            newContext.setParent(this);
            newContext.setContextStep(this);
            Iterator i = this.predicates.iterator();
            while (i.hasNext()) {
                ((Predicate)i.next()).analyze(newContext);
            }
        }
        if (this.axis == 12) {
            this.staticReturnType = contextInfo.getStaticType();
        }
    }

    public abstract Sequence eval(Sequence var1, Item var2) throws XPathException;

    public int getAxis() {
        return this.axis;
    }

    public void setPrimaryAxis(int axis) {
        this.axis = axis;
    }

    public boolean isAbbreviated() {
        return this.abbreviatedStep;
    }

    public void setAbbreviated(boolean abbrev) {
        this.abbreviatedStep = abbrev;
    }

    public void dump(ExpressionDumper dumper) {
        if (this.axis != -1) {
            dumper.display(Constants.AXISSPECIFIERS[this.axis]);
        }
        dumper.display("::");
        if (this.test != null) {
            dumper.display(this.test.toString());
        } else {
            dumper.display("node()");
        }
        if (this.predicates.size() > 0) {
            Iterator i = this.predicates.iterator();
            while (i.hasNext()) {
                ((Predicate)i.next()).dump(dumper);
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.axis != -1) {
            result.append(Constants.AXISSPECIFIERS[this.axis]);
        }
        result.append("::");
        if (this.test != null) {
            result.append(this.test.toString());
        } else {
            result.append("node()");
        }
        if (this.predicates.size() > 0) {
            Iterator i = this.predicates.iterator();
            while (i.hasNext()) {
                result.append(i.next().toString());
            }
        }
        return result.toString();
    }

    public int returnsType() {
        if (this.axis == 12) {
            return this.staticReturnType;
        }
        return -1;
    }

    public int getCardinality() {
        return 7;
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public void setTest(NodeTest test) {
        this.test = test;
    }

    public NodeTest getTest() {
        return this.test;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            pred.resetState(postOptimization);
        }
    }
}

