/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class UntypedValueCheck
extends AbstractExpression {
    private final Expression expression;
    private final int requiredType;
    private final Error error;

    public UntypedValueCheck(XQueryContext context, int requiredType, Expression expression) {
        this(context, requiredType, expression, new Error("D04"));
    }

    public UntypedValueCheck(XQueryContext context, int requiredType, Expression expression, Error error) {
        super(context);
        this.requiredType = requiredType;
        this.expression = expression;
        this.error = error;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        ValueSequence result = new ValueSequence();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (item.getType() == 21 || Type.subTypeOf(this.requiredType, 30) && Type.subTypeOf(item.getType(), 30)) {
                try {
                    item = item.convertTo(this.requiredType);
                }
                catch (XPathException e) {
                    this.error.addArgs(ExpressionDumper.dump(this.expression), Type.getTypeName(this.requiredType), Type.getTypeName(item.getType()));
                    throw new XPathException(this.expression.getASTNode(), this.error.toString());
                }
            }
            result.add(item);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("untyped-value-check[");
        dumper.display(Type.getTypeName(this.requiredType));
        dumper.display(", ");
        this.expression.dump(dumper);
        dumper.display("]");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("untyped-value-check[");
        result.append(Type.getTypeName(this.requiredType));
        result.append(", ");
        result.append(this.expression.toString());
        result.append("]");
        return result.toString();
    }

    public int returnsType() {
        return this.requiredType;
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public XQueryAST getASTNode() {
        return this.expression.getASTNode();
    }

    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }
}

