/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.text.NumberFormat;
import org.apache.log4j.Logger;
import org.exist.memtree.MemTreeBuilder;
import org.exist.util.Configuration;
import org.exist.xquery.Expression;
import org.exist.xquery.Option;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;

public class XQueryWatchDog {
    private static final Logger LOG = Logger.getLogger((Class)XQueryWatchDog.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "watchdog";
    public static final String PROPERTY_QUERY_TIMEOUT = "db-connection.watchdog.query-timeout";
    public static final String PROPERTY_OUTPUT_SIZE_LIMIT = "db-connection.watchdog.output-size-limit";
    private final XQueryContext context;
    private long timeout = Long.MAX_VALUE;
    private int maxNodesLimit = Integer.MAX_VALUE;
    private long startTime;
    private boolean terminate = false;

    public XQueryWatchDog(XQueryContext context) {
        this.context = context;
        this.configureDefaults();
        this.reset();
    }

    private void configureDefaults() {
        Configuration conf = this.context.broker.getBrokerPool().getConfiguration();
        Object option = conf.getProperty(PROPERTY_QUERY_TIMEOUT);
        if (option != null) {
            this.timeout = (Long)option;
        }
        if (this.timeout <= 0L) {
            this.timeout = Long.MAX_VALUE;
        }
        if ((option = conf.getProperty(PROPERTY_OUTPUT_SIZE_LIMIT)) != null) {
            this.maxNodesLimit = (Integer)option;
        }
    }

    public void setTimeoutFromOption(Option option) throws XPathException {
        String[] contents = option.tokenizeContents();
        if (contents.length != 1) {
            throw new XPathException("Option 'timeout' should have exactly one parameter: the timeout value.");
        }
        try {
            this.timeout = Long.parseLong(contents[0]);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Error parsing timeout value in option " + option.getQName().getStringValue());
        }
        if (LOG.isDebugEnabled()) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            LOG.debug((Object)("timeout set from option: " + nf.format(this.timeout) + " ms."));
        }
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodesLimit = maxNodes;
    }

    public void setMaxNodesFromOption(Option option) throws XPathException {
        String[] contents = option.tokenizeContents();
        if (contents.length != 1) {
            throw new XPathException("Option 'output-size-limit' should have exactly one parameter: the timeout value.");
        }
        try {
            this.setMaxNodes(Integer.parseInt(contents[0]));
        }
        catch (NumberFormatException e) {
            throw new XPathException("Error parsing size-limit value in option " + option.getQName().getStringValue());
        }
        if (LOG.isDebugEnabled()) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            LOG.debug((Object)("output-size-limit set from option: " + nf.format(this.maxNodesLimit)));
        }
    }

    public void proceed(Expression expr) throws TerminatedException {
        if (this.terminate) {
            if (expr == null) {
                expr = this.context.getRootExpression();
            }
            this.cleanUp();
            throw new TerminatedException(expr.getASTNode(), "The query has been killed by the server.");
        }
        long elapsed = System.currentTimeMillis() - this.startTime;
        if (elapsed > this.timeout) {
            if (expr == null) {
                expr = this.context.getRootExpression();
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            LOG.warn((Object)("Query exceeded predefined timeout (" + nf.format(elapsed) + " ms.): " + ExpressionDumper.dump(expr)));
            this.cleanUp();
            throw new TerminatedException.TimeoutException(expr.getASTNode(), "The query exceeded the predefined timeout and has been killed.");
        }
    }

    public void proceed(Expression expr, MemTreeBuilder builder) throws TerminatedException {
        this.proceed(expr);
        if (this.maxNodesLimit > 0 && builder.getSize() > this.maxNodesLimit) {
            if (expr == null) {
                expr = this.context.getRootExpression();
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            LOG.warn((Object)("Query exceeded predefined limit (" + nf.format(this.maxNodesLimit) + ") for document fragments: " + ExpressionDumper.dump(expr)));
            this.cleanUp();
            throw new TerminatedException.SizeLimitException(expr.getASTNode(), "The constructed document fragment exceeded the predefined size limit (current: " + nf.format(builder.getSize()) + "; allowed: " + nf.format(this.maxNodesLimit) + "). The query has been killed.");
        }
    }

    public void cleanUp() {
    }

    public void kill(long waitTime) {
        this.terminate = true;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.terminate = false;
    }

    public boolean isTerminating() {
        return this.terminate;
    }
}

