/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.text.Collator;
import java.util.Comparator;
import java.util.TreeSet;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.ValueComparison;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.CollatingFunction;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunDistinctValues
extends CollatingFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("distinct-values", "http://www.w3.org/2005/xpath-functions", ""), "Returns a sequence where duplicate values of $a, based on value equality, have been deleted.", new SequenceType[]{new SequenceType(20, 7)}, new SequenceType(20, 7)), new FunctionSignature(new QName("distinct-values", "http://www.w3.org/2005/xpath-functions", ""), "Returns a sequence where duplicate values of $a, based on value equality specified by collation $b, have been deleted.", new SequenceType[]{new SequenceType(20, 7), new SequenceType(22, 2)}, new SequenceType(20, 7))};

    public FunDistinctValues(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public int returnsType() {
        return 20;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        Collator collator = this.getCollator(contextSequence, contextItem, 2);
        TreeSet<AtomicValue> set = new TreeSet<AtomicValue>(new ValueComparator(collator));
        ValueSequence result = new ValueSequence();
        boolean hasAlreadyNaN = false;
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            AtomicValue value = item.atomize();
            if (set.contains(value)) continue;
            if (Type.subTypeOf(value.getType(), 30)) {
                if (((NumericValue)value).isNaN()) {
                    if (hasAlreadyNaN) continue;
                    set.add(value);
                    result.add(value);
                    hasAlreadyNaN = true;
                    continue;
                }
                set.add(value);
                result.add(value);
                continue;
            }
            set.add(value);
            result.add(value);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private static final class ValueComparator
    implements Comparator {
        Collator collator;

        public ValueComparator(Collator collator) {
            this.collator = collator;
        }

        public int compare(Object o1, Object o2) {
            try {
                if (ValueComparison.compareAtomic(this.collator, (AtomicValue)o1, (AtomicValue)o2, -1, 4)) {
                    return 0;
                }
                if (ValueComparison.compareAtomic(this.collator, (AtomicValue)o1, (AtomicValue)o2, -1, 0)) {
                    return -1;
                }
                if (ValueComparison.compareAtomic(this.collator, (AtomicValue)o1, (AtomicValue)o2, -1, 1)) {
                    return 1;
                }
                return ((AtomicValue)o1).compareTo(this.collator, (AtomicValue)o2);
            }
            catch (XPathException e) {
                return -1;
            }
        }
    }
}

