/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunQName
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("QName", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:QName with the namespace URI given in $a. If $a is the empty string or the empty sequence, it represents 'no namespace'. The prefix in $b is retained in the returned xs:QName value. The local name in the result is taken from the local part of $b", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2)}, new SequenceType(24, 2));

    public FunQName(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (!args[0].isEmpty() && args[0].getItemType() != 22) {
            throw new XPathException(this.getASTNode(), "err:XPTY0004: namespace URI is of type '" + Type.getTypeName(args[0].getItemType()) + "', 'xs:string' expected");
        }
        String namespace = args[0].isEmpty() ? "" : args[0].getStringValue();
        String param = args[1].getStringValue();
        String prefix = null;
        String localName = null;
        try {
            prefix = QName.extractPrefix(param);
            localName = QName.extractLocalName(param);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(this.getASTNode(), "err:FOCA0002: invalid lexical form of either prefix or local name.");
        }
        if (prefix != null && prefix.length() > 0 && (namespace == null || namespace.length() == 0)) {
            throw new XPathException(this.getASTNode(), "err:FOCA0002: non-empty namespace prefix with empty namespace URI");
        }
        QName qname = new QName(localName, namespace, prefix);
        if (prefix != null && namespace != null && this.context.getURIForPrefix(prefix) == null) {
            this.context.declareNamespace(prefix, namespace);
        }
        QNameValue result = new QNameValue(this.context, qname);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

