/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.FunStringToCodepoints;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunSubstring
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("substring", "http://www.w3.org/2005/xpath-functions"), "Returns the portion of the value of $a beginning at the position indicated by the value of $b and continuing to the end of $a. The characters returned do not extend beyond the end of $a. If $b is zero or negative, only those characters in positions greater than zero are returned. If the value of $a is the empty sequence, the zero-length string is returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(34, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("substring", "http://www.w3.org/2005/xpath-functions"), "Returns the portion of the value of $a beginning at the position indicated by the value of $b and continuing for the number of characters indicated by the value of $c. The characters returned do not extend beyond the end of $a. If $b is zero or negative, only those characters in positions greater than zero are returned. If the value of $a is the empty sequence, the zero-length string is returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(34, 2), new SequenceType(34, 2)}, new SequenceType(22, 3))};

    public FunSubstring(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public int returnsType() {
        return 22;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence seqSourceString;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Expression argSourceString = this.getArgument(0);
        Expression argStartingLoc = this.getArgument(1);
        Expression argLength = null;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seqSourceString = argSourceString.eval(contextSequence)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            String sourceString = seqSourceString.getStringValue();
            NumericValue startingLoc = ((NumericValue)argStartingLoc.eval(contextSequence).itemAt(0).convertTo(30)).round();
            if (!this.validStartPosition(startingLoc, sourceString.length())) {
                result = StringValue.EMPTY_STRING;
            } else if (this.getArgumentCount() > 2) {
                argLength = this.getArgument(2);
                NumericValue length = new IntegerValue(sourceString.length());
                length = ((NumericValue)argLength.eval(contextSequence).itemAt(0).convertTo(30)).round();
                NumericValue endingLoc = !length.isInfinite() ? new IntegerValue(startingLoc.getInt() + length.getInt()) : length;
                result = !this.validEndPosition(endingLoc, startingLoc) ? StringValue.EMPTY_STRING : (endingLoc.getInt() > sourceString.length() || endingLoc.isInfinite() ? this.substring(sourceString, startingLoc) : this.substring(sourceString, startingLoc, endingLoc));
            } else {
                result = this.substring(sourceString, startingLoc);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private boolean validStartPosition(NumericValue startPosition, int stringLength) {
        if (startPosition.isNaN()) {
            return false;
        }
        if (startPosition.isInfinite()) {
            return false;
        }
        try {
            if (startPosition.getInt() > stringLength) {
                return false;
            }
        }
        catch (XPathException xpe) {
            return false;
        }
        return true;
    }

    private boolean validEndPosition(NumericValue end, NumericValue start) throws XPathException {
        if (end.isNaN()) {
            return false;
        }
        if (end.isInfinite()) {
            return true;
        }
        if (end.getInt() < 1) {
            return false;
        }
        return end.getInt() > start.getInt();
    }

    private StringValue substring(String sourceString, NumericValue startingLoc) throws XPathException {
        if (startingLoc.getInt() <= 1) {
            return new StringValue(sourceString);
        }
        ValueSequence codepoints = FunStringToCodepoints.getCodePoints(sourceString);
        return new StringValue(FunStringToCodepoints.subSequence(codepoints, startingLoc.getInt() - 1));
    }

    private StringValue substring(String sourceString, NumericValue startingLoc, NumericValue endingLoc) throws XPathException {
        ValueSequence codepoints = FunStringToCodepoints.getCodePoints(sourceString);
        return new StringValue(FunStringToCodepoints.subSequence(codepoints, startingLoc.getInt() - 1, endingLoc.getInt() - 1));
    }
}

