/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunSum
extends Function {
    private boolean gotInfinity = false;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("sum", "http://www.w3.org/2005/xpath-functions"), "Returns a value obtained by adding together the values in $a. If the single-argument form of the function is used, then the value returned for an empty sequence is the xs:double value 0.0e0.", new SequenceType[]{new SequenceType(20, 7)}, new SequenceType(20, 2)), new FunctionSignature(new QName("sum", "http://www.w3.org/2005/xpath-functions"), "Returns a value obtained by adding together the values in $a. If the single-argument form of the function is used, then the value returned for an empty sequence is the xs:double value 0.0e0. If the two-argument form is used, then the value returned for an empty sequence is the value of the $b argument.", new SequenceType[]{new SequenceType(20, 7), new SequenceType(20, 3)}, new SequenceType(20, 3))};

    public FunSum(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        ComputableValue result;
        Sequence inner;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((inner = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            Sequence zero = IntegerValue.ZERO;
            if (this.getSignature().getArgumentCount() == 2) {
                zero = this.getArgument(1).eval(contextSequence, contextItem);
            }
            result = zero;
        } else {
            SequenceIterator iter = inner.iterate();
            Item item = iter.nextItem();
            AtomicValue value = item.atomize();
            if (value.getType() == 21) {
                value = value.convertTo(34);
            }
            if (!(value instanceof ComputableValue)) {
                throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(value.getType()) + "(" + value + ")' can not be an operand in a sum");
            }
            ComputableValue sum = (ComputableValue)value;
            while (iter.hasNext()) {
                item = iter.nextItem();
                value = item.atomize();
                if (value.getType() == 21) {
                    value = value.convertTo(34);
                }
                if (!(value instanceof ComputableValue)) {
                    throw new XPathException(this.getASTNode(), "XPTY0004: '" + Type.getTypeName(value.getType()) + "(" + value + ")' can not be an operand in a sum");
                }
                if (Type.subTypeOf(value.getType(), 30)) {
                    if (((NumericValue)value).isInfinite()) {
                        this.gotInfinity = true;
                    }
                    if (((NumericValue)value).isNaN()) {
                        sum = DoubleValue.NaN;
                        break;
                    }
                }
                sum = (ComputableValue)sum.promote(value);
                sum = sum.plus((ComputableValue)value);
            }
            result = sum;
        }
        if (this.gotInfinity || !Type.subTypeOf(result.getItemType(), 30) || ((NumericValue)result).isInfinite()) {
            // empty if block
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

