/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.exist.dom.QName;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class AsUser
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("as-user", "http://exist-db.org/xquery/system", "system"), "A pseudo-function to execute a limited block of code as a different user. The first argument is the name of the user, the second is the password. If the user can be authenticated, the function will execute the code block given in the third argument with the permissions of that user andreturns the result of the execution. Before the function completes, it switches the current user back to the old user.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 3), new SequenceType(11, 7)}, new SequenceType(11, 7));

    public AsUser(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence userSeq = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence passwdSeq = this.getArgument(1).eval(contextSequence, contextItem);
        if (userSeq.isEmpty()) {
            throw new XPathException(this.getASTNode(), "No user specified");
        }
        String userName = userSeq.getStringValue();
        String passwd = passwdSeq.getStringValue();
        SecurityManager security = this.context.getBroker().getBrokerPool().getSecurityManager();
        User user = security.getUser(userName);
        if (user == null) {
            throw new XPathException(this.getASTNode(), "Authentication failed");
        }
        if (user.validate(passwd)) {
            User oldUser = this.context.getBroker().getUser();
            try {
                this.context.getBroker().setUser(user);
                Sequence sequence = this.getArgument(2).eval(contextSequence, contextItem);
                return sequence;
            }
            finally {
                this.context.getBroker().setUser(oldUser);
            }
        }
        throw new XPathException(this.getASTNode(), "Authentication failed");
    }

    public int getDependencies() {
        return this.getArgument(2).getDependencies();
    }

    public int returnsType() {
        return this.getArgument(2).returnsType();
    }
}

