/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.util.Date;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.storage.ProcessMonitor;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetRunningJobs
extends BasicFunction {
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/system";
    static final String PREFIX = "system";
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-running-jobs", "http://exist-db.org/xquery/system", "system"), "Get a list of running jobs (dba role only).", null, new SequenceType(11, 2));

    public GetRunningJobs(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getUser().hasDbaRole()) {
            throw new XPathException(this.getASTNode(), "Permission denied, calling user '" + this.context.getUser().getName() + "' must be a DBA to get the list of running xqueries");
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("jobs", NAMESPACE_URI, PREFIX), null);
        ProcessMonitor monitor = this.context.getBroker().getBrokerPool().getProcessMonitor();
        ProcessMonitor.JobInfo[] jobs = monitor.runningJobs();
        for (int i = 0; i < jobs.length; ++i) {
            Thread process = jobs[i].getThread();
            Date startDate = new Date(jobs[i].getStartTime());
            builder.startElement(new QName("job", NAMESPACE_URI, PREFIX), null);
            builder.addAttribute(new QName("id", null, null), process.getName());
            builder.addAttribute(new QName("action", null, null), jobs[i].getAction());
            builder.addAttribute(new QName("start", null, null), new DateTimeValue(startDate).getStringValue());
            builder.addAttribute(new QName("info", null, null), jobs[i].getAddInfo().toString());
            builder.endElement();
        }
        builder.endElement();
        builder.endDocument();
        return (NodeValue)((Object)builder.getDocument().getDocumentElement());
    }
}

