/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import java.util.ArrayList;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.dom.TextImpl;
import org.exist.memtree.MemTreeBuilder;
import org.exist.util.FastQSort;
import org.exist.util.XMLString;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.DOMException;

public class HighlightMatches
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("highlight-matches", "http://exist-db.org/xquery/text", "text"), "Highlight matching strings within text nodes that resulted from a fulltext search. When searching with one of the fulltext operators or functions, eXist keeps track of the fulltext matches within the text. Usually, the serializer will mark those matches by enclosing them into an 'exist:match' element. One can then use an XSLT stylesheet to replace those match elements and highlight matches to the user. However, this is not always possible, so Instead of using an XSLT to post-process the serialized output, the highlight-matches function provides direct access to the matching portions of the text within XQuery. The function takes a sequence of text nodes as first argument $a and a callback function (defined with util:function) as second parameter $b. $c may contain a sequence of additional values that will be passed to the callback functions third parameter. Text nodes without matches will be returned as they are. However, if the text contains a match marker, the matching character sequence is reported to the callback function, and the result of the function call is inserted into the resulting node set where the matching sequence occurred. For example, you can use this to mark all matching terms with a <span class=\"highlight\">abc</span>.", new SequenceType[]{new SequenceType(3, 7), new SequenceType(101, 2), new SequenceType(11, 7)}, new SequenceType(-1, 7));

    public HighlightMatches(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        FunctionReference func = (FunctionReference)args[1].itemAt(0);
        FunctionCall call = func.getFunctionCall();
        this.context.pushDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        ValueSequence result = new ValueSequence();
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            NodeValue v = (NodeValue)i.nextItem();
            if (v.getImplementationType() == 0) {
                result.add(v);
                continue;
            }
            NodeProxy p = (NodeProxy)v;
            this.processText(builder, p, result, call, args[2]);
        }
        this.context.popDocumentContext();
        return result;
    }

    private final void processText(MemTreeBuilder builder, NodeProxy proxy, Sequence result, FunctionCall callback, Sequence extraArgs) throws DOMException, XPathException {
        TextImpl text = (TextImpl)proxy.getNode();
        Match match = proxy.getMatches();
        if (match == null) {
            int nodeNr = builder.characters(text.getXMLString());
            result.add(builder.getDocument().getNode(nodeNr));
        } else {
            ArrayList<Match.Offset> offsets = null;
            for (Match next = match; next != null; next = next.getNextMatch()) {
                if (!next.getNodeId().equals(text.getNodeId())) continue;
                if (offsets == null) {
                    offsets = new ArrayList<Match.Offset>();
                }
                int freq = next.getFrequency();
                for (int i = 0; i < freq; ++i) {
                    offsets.add(next.getOffset(i));
                }
            }
            if (offsets != null) {
                int nodeNr;
                FastQSort.sort(offsets, 0, offsets.size() - 1);
                XMLString str = text.getXMLString();
                int pos = 0;
                for (int i = 0; i < offsets.size(); ++i) {
                    Match.Offset offset = (Match.Offset)offsets.get(i);
                    if (offset.getOffset() > pos) {
                        nodeNr = builder.characters(str.substring(pos, offset.getOffset() - pos));
                        result.add(builder.getDocument().getNode(nodeNr));
                    }
                    Sequence[] params = new Sequence[]{new StringValue(str.substring(offset.getOffset(), offset.getLength())), proxy, extraArgs};
                    result.addAll(callback.evalFunction(null, null, params));
                    pos = offset.getOffset() + offset.getLength();
                }
                if (pos < str.length()) {
                    nodeNr = builder.characters(str.substring(pos, str.length() - pos));
                    result.add(builder.getDocument().getNode(nodeNr));
                }
            } else {
                int nodeNr = builder.characters(text.getXMLString());
                result.add(builder.getDocument().getNode(nodeNr));
            }
        }
    }
}

