/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import org.exist.dom.QName;
import org.exist.storage.analysis.SimpleTokenizer;
import org.exist.storage.analysis.TextToken;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class Tokenize
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("make-token", "http://exist-db.org/xquery/text", "text"), "split a string into a token", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 7));

    public Tokenize(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ValueSequence result = new ValueSequence();
        SimpleTokenizer tokenizer = new SimpleTokenizer();
        tokenizer.setText(args[0].getStringValue());
        TextToken token = tokenizer.nextToken(false);
        while (token != null && token.getType() != -1) {
            result.add(new StringValue(token.getText()));
            token = tokenizer.nextToken(false);
        }
        return result;
    }
}

