/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.ArrayList;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class CallFunction
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("call", "http://exist-db.org/xquery/util", "util"), "Invokes a first-class function reference created by util:function. The function to be called is passed as the first argument. All remaining arguments are forwarded to the called function.", new SequenceType[]{new SequenceType(101, 2), new SequenceType(11, 7)}, new SequenceType(11, 7), true);

    public CallFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence arg0 = this.getArgument(0).eval(contextSequence, contextItem);
        if (arg0.getCardinality() != 2) {
            throw new XPathException(this.getASTNode(), "Expected exactly one item for first argument");
        }
        Item item0 = arg0.itemAt(0);
        if (item0.getType() != 101) {
            throw new XPathException(this.getASTNode(), "Type error: expected function, got " + Type.getTypeName(item0.getType()));
        }
        FunctionReference ref = (FunctionReference)item0;
        FunctionCall call = ref.getFunctionCall();
        ArrayList<Expression> params = new ArrayList<Expression>(this.getArgumentCount() - 1);
        for (int i = 1; i < this.getArgumentCount(); ++i) {
            params.add(this.getArgument(i));
        }
        call.setArguments(params);
        call.analyze(new AnalyzeContextInfo(this, 0));
        return call.eval(contextSequence);
    }
}

