/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.numbering.NodeId;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetNodeById
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("node-by-id", "http://exist-db.org/xquery/util", "util"), "Retrieves a node by its internal node-id. The document is specified via the first argument. It may either be a document node or another node from the same document from which the target node will be retrieved by its id. The second argument is the internal node-id, specified as a string. Please note: the function does not check if the passed id does really point to an existing node. It just returns a pointer, which may thus be invalid.", new SequenceType[]{new SequenceType(-1, 2), new SequenceType(22, 2)}, new SequenceType(-1, 2));

    public GetNodeById(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue docNode = (NodeValue)args[0].itemAt(0);
        if (docNode.getImplementationType() == 0) {
            throw new XPathException(this.getASTNode(), "First argument to function node-by-id should be a persistent node, not an in-memory node.");
        }
        DocumentImpl doc = ((NodeProxy)docNode).getDocument();
        String id = args[1].itemAt(0).getStringValue();
        NodeId nodeId = this.context.getBroker().getBrokerPool().getNodeFactory().createFromString(id);
        NodeProxy node = new NodeProxy(doc, nodeId);
        return node;
    }
}

