/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.security.MessageDigester;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class Hash
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("hash", "http://exist-db.org/xquery/util", "util"), "Calculate an hashcode from string $a using alghorithm $b.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(22, 2)), new FunctionSignature(new QName("hash", "http://exist-db.org/xquery/util", "util"), "Calculate an hashcode from string $a using alghorithm $b. $c specifies whether to return result Base64 encoded", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2), new SequenceType(23, 2)}, new SequenceType(22, 2))};

    public Hash(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        boolean base64 = false;
        String message = args[0].itemAt(0).getStringValue();
        String algorithm = args[1].itemAt(0).getStringValue();
        if (args.length > 2) {
            base64 = args[2].effectiveBooleanValue();
        }
        String md = null;
        try {
            md = MessageDigester.calculate(message, algorithm, base64);
        }
        catch (IllegalArgumentException ex) {
            throw new XPathException(ex.getMessage());
        }
        return new StringValue(md);
    }
}

