/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.DocumentSet;
import org.exist.util.LockException;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class LockFunction
extends Function {
    protected final boolean exclusive;

    protected LockFunction(XQueryContext context, FunctionSignature signature, boolean exclusive) {
        super(context, signature);
        this.exclusive = exclusive;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence docsArg = this.getArgument(0).eval(contextSequence, contextItem);
        DocumentSet docs = docsArg.getDocumentSet();
        try {
            docs.lock(this.context.getBroker(), this.exclusive, false);
            Sequence sequence = this.getArgument(1).eval(contextSequence, contextItem);
            Object var7_7 = null;
            docs.unlock(this.exclusive);
            return sequence;
        }
        catch (LockException e) {
            try {
                throw new XPathException(this.getASTNode(), "Could not lock document set", e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                docs.unlock(this.exclusive);
                throw throwable;
            }
        }
    }

    public int getCardinality() {
        return this.getArgument(1).getCardinality();
    }

    public int returnsType() {
        return this.getArgument(1).returnsType();
    }
}

