/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.User;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCreateUser
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("create-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Create a new user in the database. Arguments are: username, password, group memberships and home collection.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 6), new SequenceType(22, 3)}, new SequenceType(11, 1));

    public XMLDBCreateUser(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String user = args[0].getStringValue();
        String pass = args[1].getStringValue();
        User userObj = new User(user, pass);
        LOG.info((Object)("Attempting to create user " + user));
        Sequence groups = args[2];
        int len = groups.getItemCount();
        for (int x = 0; x < len; ++x) {
            userObj.addGroup(groups.itemAt(x).getStringValue());
        }
        if (!"".equals(args[3].getStringValue())) {
            try {
                userObj.setHome(new AnyURIValue(args[3].getStringValue()).toXmldbURI());
            }
            catch (XPathException e) {
                throw new XPathException(this.getASTNode(), "Invalid home collection URI", e);
            }
        }
        LocalCollection collection = null;
        try {
            try {
                collection = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI, this.context.getAccessContext());
                UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
                ums.addUser(userObj);
            }
            catch (XMLDBException xe) {
                throw new XPathException(this.getASTNode(), "Failed to create new user " + user, xe);
            }
            Object var11_13 = null;
            if (null == collection) return Sequence.EMPTY_SEQUENCE;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (null == collection) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (XMLDBException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (XMLDBException e) {}
        collection.close();
        return Sequence.EMPTY_SEQUENCE;
    }
}

