/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBMove
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("move", "http://exist-db.org/xquery/xmldb", "xmldb"), "Move a collection $a. The collection can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(11, 1)), new FunctionSignature(new QName("move", "http://exist-db.org/xquery/xmldb", "xmldb"), "Move a resource $c from the collection specified in $a to collection in $b. The collection can be either specified as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(11, 1))};

    public XMLDBMove(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        String destination = new AnyURIValue(args[1].itemAt(0).getStringValue()).toXmldbURI().toString();
        if (this.getSignature().getArgumentCount() == 3) {
            String doc = new AnyURIValue(args[2].itemAt(0).getStringValue()).toXmldbURI().toString();
            try {
                Resource resource = collection.getResource(doc);
                if (resource == null) {
                    throw new XPathException(this.getASTNode(), "Resource " + doc + " not found");
                }
                CollectionManagementServiceImpl service = (CollectionManagementServiceImpl)collection.getService("CollectionManagementService", "1.0");
                service.moveResource(doc, destination, null);
            }
            catch (XMLDBException e) {
                throw new XPathException(this.getASTNode(), "XMLDB exception caught: " + e.getMessage(), e);
            }
        }
        try {
            CollectionManagementServiceImpl service = (CollectionManagementServiceImpl)collection.getService("CollectionManagementService", "1.0");
            service.move(collection.getName(), destination, null);
        }
        catch (XMLDBException e) {
            throw new XPathException(this.getASTNode(), "Cannot move collection: " + e.getMessage(), e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

