/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.serializer.ExtendedDOMSerializer;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class XMLDBXUpdate
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature signature = new FunctionSignature(new QName("update", "http://exist-db.org/xquery/xmldb", "xmldb"), "Process an XUpdate request against a collection. The first argument specifies the collection as a simple collection path or an XMLDB URI. The second argument specifies the XUpdate modifications to be processed. Modifications are passed in a document conforming to the XUpdate specification. The function returns the number of modifications caused by the XUpdate.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(-1, 2)}, new SequenceType(31, 2));

    public XMLDBXUpdate(XQueryContext context) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection c, Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue data = (NodeValue)args[1].itemAt(0);
        StringWriter writer = new StringWriter();
        Properties properties = new Properties();
        properties.setProperty("indent", "yes");
        ExtendedDOMSerializer serializer = new ExtendedDOMSerializer(this.context.getBroker(), writer, properties);
        try {
            serializer.serialize(data.getNode());
        }
        catch (TransformerException e) {
            LOG.debug((Object)"Exception while serializing XUpdate document", (Throwable)e);
            throw new XPathException(this.getASTNode(), "Exception while serializing XUpdate document: " + e.getMessage(), e);
        }
        String xupdate = writer.toString();
        long modifications = 0L;
        try {
            XUpdateQueryService service = (XUpdateQueryService)c.getService("XUpdateQueryService", "1.0");
            LOG.debug((Object)("Processing XUpdate request: " + xupdate));
            modifications = service.update(xupdate);
        }
        catch (XMLDBException e) {
            throw new XPathException(this.getASTNode(), "Exception while processing xupdate: " + e.getMessage(), e);
        }
        this.context.getRootExpression().resetState(false);
        return new IntegerValue(modifications);
    }
}

