/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class GYearMonthValue
extends AbstractDateTimeValue {
    public GYearMonthValue() throws XPathException {
        super(GYearMonthValue.stripCalendar(TimeUtils.getInstance().newXMLGregorianCalendar(new GregorianCalendar())));
    }

    public GYearMonthValue(XMLGregorianCalendar calendar) throws XPathException {
        super(GYearMonthValue.stripCalendar((XMLGregorianCalendar)calendar.clone()));
    }

    public GYearMonthValue(String timeValue) throws XPathException {
        super(timeValue);
        try {
            if (this.calendar.getXMLSchemaType() != DatatypeConstants.GYEARMONTH) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException e) {
            throw new XPathException("xs:gYearMonth instance must not have year, month or day fields set");
        }
    }

    private static XMLGregorianCalendar stripCalendar(XMLGregorianCalendar calendar) {
        calendar = (XMLGregorianCalendar)calendar.clone();
        calendar.setDay(Integer.MIN_VALUE);
        calendar.setHour(Integer.MIN_VALUE);
        calendar.setMinute(Integer.MIN_VALUE);
        calendar.setSecond(Integer.MIN_VALUE);
        calendar.setMillisecond(Integer.MIN_VALUE);
        return calendar;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 59: {
                return new GYearMonthValue(this.calendar);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:time to " + Type.getTypeName(requiredType));
    }

    protected AbstractDateTimeValue createSameKind(XMLGregorianCalendar cal) throws XPathException {
        return new GYearMonthValue(cal);
    }

    public int getType() {
        return 59;
    }

    protected QName getXMLSchemaType() {
        return DatatypeConstants.GYEARMONTH;
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == this.getType()) {
            int r;
            if (!this.getTimezone().isEmpty()) {
                if (!((AbstractDateTimeValue)other).getTimezone().isEmpty()) {
                    if (!((DayTimeDurationValue)this.getTimezone().itemAt(0)).compareTo(null, 4, (DayTimeDurationValue)((AbstractDateTimeValue)other).getTimezone().itemAt(0))) {
                        return -1;
                    }
                    if (this.getTrimmedCalendar().compare(((AbstractDateTimeValue)other).getTrimmedCalendar()) == 0) {
                        return 0;
                    }
                    if (!((DayTimeDurationValue)this.getTimezone().itemAt(0)).getStringValue().equals("PT0S")) {
                        return -1;
                    }
                } else if (!((AbstractDateTimeValue)other).getTimezone().isEmpty() && !((DayTimeDurationValue)((AbstractDateTimeValue)other).getTimezone().itemAt(0)).getStringValue().equals("PT0S")) {
                    return -1;
                }
            }
            if ((r = this.getTrimmedCalendar().compare(((AbstractDateTimeValue)other).getTrimmedCalendar())) == 2) {
                throw new RuntimeException("indeterminate order between " + this + " and " + other);
            }
            return r;
        }
        throw new XPathException("Type error: cannot compare " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        throw new XPathException("Subtraction is not supported on values of type " + Type.getTypeName(this.getType()));
    }
}

